/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.dto;

import io.mosip.kernel.keymanagerservice.dto.SignatureRequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing a PDF sign request")
public class PDFSignatureRequestDto
extends SignatureRequestDto {
    @ApiModelProperty(notes="The lower left x value of sign rectangle.", required=true)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=0L) @Max(value=0x7FFFFFFFL) int lowerLeftX;
    @ApiModelProperty(notes="The lower left y value of sign rectangle.", required=true)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=0L) @Max(value=0x7FFFFFFFL) int lowerLeftY;
    @ApiModelProperty(notes="The upper right x value of sign rectangle.", required=true)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=0L) @Max(value=0x7FFFFFFFL) int upperRightX;
    @ApiModelProperty(notes="The upper right y value of sign rectangle.", required=true)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=0L) @Max(value=0x7FFFFFFFL) int upperRightY;
    @ApiModelProperty(notes="Reason for signing.", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String reason;
    @ApiModelProperty(notes="Page number for signature.", required=true)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=0L) @Max(value=0x7FFFFFFFL) int pageNumber;
    @ApiModelProperty(notes="Password for protecting PDF")
    private String password;

    @Generated
    public int getLowerLeftX() {
        return this.lowerLeftX;
    }

    @Generated
    public int getLowerLeftY() {
        return this.lowerLeftY;
    }

    @Generated
    public int getUpperRightX() {
        return this.upperRightX;
    }

    @Generated
    public int getUpperRightY() {
        return this.upperRightY;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setLowerLeftX(int lowerLeftX) {
        this.lowerLeftX = lowerLeftX;
    }

    @Generated
    public void setLowerLeftY(int lowerLeftY) {
        this.lowerLeftY = lowerLeftY;
    }

    @Generated
    public void setUpperRightX(int upperRightX) {
        this.upperRightX = upperRightX;
    }

    @Generated
    public void setUpperRightY(int upperRightY) {
        this.upperRightY = upperRightY;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String toString() {
        return "PDFSignatureRequestDto(lowerLeftX=" + this.getLowerLeftX() + ", lowerLeftY=" + this.getLowerLeftY() + ", upperRightX=" + this.getUpperRightX() + ", upperRightY=" + this.getUpperRightY() + ", reason=" + this.getReason() + ", pageNumber=" + this.getPageNumber() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDFSignatureRequestDto)) {
            return false;
        }
        PDFSignatureRequestDto other = (PDFSignatureRequestDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLowerLeftX() != other.getLowerLeftX()) {
            return false;
        }
        if (this.getLowerLeftY() != other.getLowerLeftY()) {
            return false;
        }
        if (this.getUpperRightX() != other.getUpperRightX()) {
            return false;
        }
        if (this.getUpperRightY() != other.getUpperRightY()) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PDFSignatureRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLowerLeftX();
        result = result * 59 + this.getLowerLeftY();
        result = result * 59 + this.getUpperRightX();
        result = result * 59 + this.getUpperRightY();
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        result = result * 59 + this.getPageNumber();
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @ConstructorProperties(value={"lowerLeftX", "lowerLeftY", "upperRightX", "upperRightY", "reason", "pageNumber", "password"})
    @Generated
    public PDFSignatureRequestDto(int lowerLeftX, int lowerLeftY, int upperRightX, int upperRightY, String reason, int pageNumber, String password) {
        this.lowerLeftX = lowerLeftX;
        this.lowerLeftY = lowerLeftY;
        this.upperRightX = upperRightX;
        this.upperRightY = upperRightY;
        this.reason = reason;
        this.pageNumber = pageNumber;
        this.password = password;
    }

    @Generated
    public PDFSignatureRequestDto() {
    }
}

