/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.keymanagerservice.dto.PDFSignatureRequestDto;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureResponseDto;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(tags={"keymanager"}, value="Operation related to Keymanagement")
public class KeymanagerController {
    @Value(value="${mosip.sign.refid:SIGN}")
    private String certificateSignRefID;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Autowired
    KeymanagerService keymanagerService;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @GetMapping(value={"/publickey/{applicationId}"})
    public ResponseWrapper<PublicKeyResponse<String>> getPublicKey(@ApiParam(value="Id of application") @PathVariable(value="applicationId") String applicationId, @ApiParam(value="Timestamp as metadata") @RequestParam(value="timeStamp") String timestamp, @ApiParam(value="Refrence Id as metadata") @RequestParam(value="referenceId") Optional<String> referenceId) {
        ResponseWrapper response = new ResponseWrapper();
        if (applicationId.equalsIgnoreCase(this.signApplicationid) && referenceId.isPresent() && referenceId.get().equals(this.certificateSignRefID)) {
            response.setResponse((Object)this.keymanagerService.getSignPublicKey(applicationId, timestamp, referenceId));
        } else {
            response.setResponse((Object)this.keymanagerService.getPublicKey(applicationId, timestamp, referenceId));
        }
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/pdf/sign"})
    public ResponseWrapper<SignatureResponseDto> signPDF(@RequestBody @Valid RequestWrapper<PDFSignatureRequestDto> signatureResponseDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.signPDF((PDFSignatureRequestDto)signatureResponseDto.getRequest()));
        return response;
    }
}

