/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.util;

import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerErrorCode;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CryptomanagerUtils {
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name}")
    private String symmetricAlgorithmName;
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Autowired
    private KeymanagerService keyManager;

    public PublicKey getPublicKey(CryptomanagerRequestDto cryptomanagerRequestDto) {
        try {
            String publicKey = this.getPublicKeyFromKeyManager(cryptomanagerRequestDto.getApplicationId(), DateUtils.formatToISOString((LocalDateTime)cryptomanagerRequestDto.getTimeStamp()), cryptomanagerRequestDto.getReferenceId());
            return KeyFactory.getInstance(this.asymmetricAlgorithmName).generatePublic(new X509EncodedKeySpec(CryptoUtil.decodeBase64((String)publicKey)));
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(CryptomanagerErrorCode.INVALID_SPEC_PUBLIC_KEY.getErrorCode(), CryptomanagerErrorCode.INVALID_SPEC_PUBLIC_KEY.getErrorMessage());
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(CryptomanagerErrorCode.NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), CryptomanagerErrorCode.NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage());
        }
    }

    private String getPublicKeyFromKeyManager(String appId, String timestamp, String refId) {
        return (String)this.keyManager.getPublicKey(appId, timestamp, Optional.ofNullable(refId)).getPublicKey();
    }

    public SecretKey getDecryptedSymmetricKey(CryptomanagerRequestDto cryptomanagerRequestDto) {
        byte[] symmetricKey = CryptoUtil.decodeBase64((String)this.decryptSymmetricKeyUsingKeyManager(cryptomanagerRequestDto));
        return new SecretKeySpec(symmetricKey, 0, symmetricKey.length, this.symmetricAlgorithmName);
    }

    private String decryptSymmetricKeyUsingKeyManager(CryptomanagerRequestDto cryptomanagerRequestDto) {
        SymmetricKeyRequestDto symmetricKeyRequestDto = new SymmetricKeyRequestDto(cryptomanagerRequestDto.getApplicationId(), cryptomanagerRequestDto.getTimeStamp(), cryptomanagerRequestDto.getReferenceId(), cryptomanagerRequestDto.getData());
        return this.keyManager.decryptSymmetricKey(symmetricKeyRequestDto).getSymmetricKey();
    }

    public static String nullOrTrim(String parameter) {
        return parameter == null ? null : parameter.trim();
    }

    public boolean isValidSalt(String salt) {
        return salt != null && !salt.trim().isEmpty();
    }

    public LocalDateTime parseToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }
}

