/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerResponseDto;
import io.mosip.kernel.cryptomanager.service.CryptomanagerService;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CryptomanagerServiceImpl
implements CryptomanagerService {
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Autowired
    KeyGenerator keyGenerator;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    public CryptomanagerResponseDto encrypt(CryptomanagerRequestDto cryptoRequestDto) {
        SecretKey secretKey = this.keyGenerator.getSymmetricKey();
        byte[] encryptedData = this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())) ? (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)CryptoUtil.decodeBase64((String)cryptoRequestDto.getData()), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad()))) : (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)CryptoUtil.decodeBase64((String)cryptoRequestDto.getData()), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad())));
        PublicKey publicKey = this.cryptomanagerUtil.getPublicKey(cryptoRequestDto);
        byte[] encryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)publicKey, (Object)secretKey.getEncoded());
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        cryptoResponseDto.setData(CryptoUtil.encodeBase64((byte[])CryptoUtil.combineByteArray((byte[])encryptedData, (byte[])encryptedSymmetricKey, (String)this.keySplitter)));
        return cryptoResponseDto;
    }

    public CryptomanagerResponseDto decrypt(CryptomanagerRequestDto cryptoRequestDto) {
        int keyDemiliterIndex = 0;
        byte[] encryptedHybridData = CryptoUtil.decodeBase64((String)cryptoRequestDto.getData());
        keyDemiliterIndex = CryptoUtil.getSplitterIndex((byte[])encryptedHybridData, (int)keyDemiliterIndex, (String)this.keySplitter);
        byte[] encryptedKey = Arrays.copyOfRange(encryptedHybridData, 0, keyDemiliterIndex);
        byte[] encryptedData = Arrays.copyOfRange(encryptedHybridData, keyDemiliterIndex + this.keySplitter.length(), encryptedHybridData.length);
        cryptoRequestDto.setData(CryptoUtil.encodeBase64((byte[])encryptedKey));
        SecretKey decryptedSymmetricKey = this.cryptomanagerUtil.getDecryptedSymmetricKey(cryptoRequestDto);
        byte[] decryptedData = this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())) ? (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad()))) : (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad())));
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        cryptoResponseDto.setData(CryptoUtil.encodeBase64((byte[])decryptedData));
        return cryptoResponseDto;
    }
}

