/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keygenerator.bouncycastle.util;

import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.keygenerator.bouncycastle.constant.KeyGeneratorExceptionConstant;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyGeneratorUtils {
    private static BouncyCastleProvider provider = KeyGeneratorUtils.init();

    private KeyGeneratorUtils() {
    }

    public static KeyGenerator getKeyGenerator(String algorithmName, int keylength) {
        KeyGenerator generator = null;
        try {
            generator = KeyGenerator.getInstance(algorithmName, (Provider)provider);
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        SecureRandom random = new SecureRandom();
        generator.init(keylength, random);
        return generator;
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithmName, int keylength) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(algorithmName, (Provider)provider);
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        SecureRandom random = new SecureRandom();
        generator.initialize(keylength, random);
        return generator;
    }

    private static BouncyCastleProvider init() {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
        return provider;
    }
}

