/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keygenerator.bouncycastle;

import io.mosip.kernel.keygenerator.bouncycastle.util.KeyGeneratorUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeyGenerator {
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name}")
    private String symmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.symmetric-key-length}")
    private int symmetricKeyLength;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-key-length}")
    private int asymmetricKeyLength;

    public SecretKey getSymmetricKey() {
        javax.crypto.KeyGenerator generator = KeyGeneratorUtils.getKeyGenerator(this.symmetricKeyAlgorithm, this.symmetricKeyLength);
        return generator.generateKey();
    }

    public KeyPair getAsymmetricKey() {
        KeyPairGenerator generator = KeyGeneratorUtils.getKeyPairGenerator(this.asymmetricKeyAlgorithm, this.asymmetricKeyLength);
        return generator.generateKeyPair();
    }
}

