/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idvalidator.vid.impl;

import io.mosip.kernel.core.idvalidator.exception.InvalidIDException;
import io.mosip.kernel.core.idvalidator.spi.VidValidator;
import io.mosip.kernel.core.util.ChecksumUtils;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.idvalidator.vid.constant.VidExceptionConstant;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VidValidatorImpl
implements VidValidator<String> {
    @Value(value="#{'${mosip.kernel.vid.restricted-numbers}'.split(',')}")
    private List<String> restrictedAdminDigits;
    @Value(value="${mosip.kernel.vid.length}")
    private int vidLength;
    private String numaricRegEx;
    @Value(value="${mosip.kernel.vid.length.sequence-limit}")
    private int sequenceLimit;
    @Value(value="${mosip.kernel.vid.length.repeating-block-limit}")
    private int repeatingBlockLimit;
    @Value(value="${mosip.kernel.vid.length.repeating-limit}")
    private int repeatingLimit;
    @Value(value="#{'${mosip.kernel.vid.not-start-with}'.split(',')}")
    private List<String> notStartWith;
    private static final String SEQ_ASC = "0123456789";
    private static final String SEQ_DEC = "9876543210";
    private Pattern repeatingPattern = null;
    private Pattern repeatingBlockPattern = null;
    private static final char CHAR_ZERO = '0';
    private static final char CHAR_ONE = '1';

    @PostConstruct
    private void vidValidatorImplPostConstruct() {
        this.numaricRegEx = "\\d{" + this.vidLength + "}";
        if (this.repeatingLimit > 0) {
            String repeatingRegEx = "(\\d)\\d{0," + (this.repeatingLimit - 1) + "}\\1";
            this.repeatingPattern = Pattern.compile(repeatingRegEx);
        }
        if (this.repeatingBlockLimit > 0) {
            String repeatingBlockRegEx = "(\\d{" + this.repeatingBlockLimit + ",}).*?\\1";
            this.repeatingBlockPattern = Pattern.compile(repeatingBlockRegEx);
        }
    }

    public boolean validateId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new InvalidIDException(VidExceptionConstant.VID_VAL_INVALID_NULL.getErrorCode(), VidExceptionConstant.VID_VAL_INVALID_NULL.getErrorMessage());
        }
        if (id.length() != this.vidLength) {
            throw new InvalidIDException(VidExceptionConstant.VID_VAL_ILLEGAL_LENGTH.getErrorCode(), VidExceptionConstant.VID_VAL_ILLEGAL_LENGTH.getErrorMessage());
        }
        if (this.numaricRegEx != null && !Pattern.matches(this.numaricRegEx, id)) {
            throw new InvalidIDException(VidExceptionConstant.VID_VAL_INVALID_DIGITS.getErrorCode(), VidExceptionConstant.VID_VAL_INVALID_DIGITS.getErrorMessage());
        }
        if (id.charAt(0) == '0' || id.charAt(0) == '1') {
            // empty if block
        }
        if (!this.isValidId(id)) {
            throw new InvalidIDException(VidExceptionConstant.VID_VAL_ILLEGAL_SEQUENCE_REPEATATIVE.getErrorCode(), VidExceptionConstant.VID_VAL_ILLEGAL_SEQUENCE_REPEATATIVE.getErrorMessage());
        }
        if (!ChecksumUtils.validateChecksum((String)id)) {
            throw new InvalidIDException(VidExceptionConstant.VID_VAL_ILLEGAL_CHECKSUM.getErrorCode(), VidExceptionConstant.VID_VAL_ILLEGAL_CHECKSUM.getErrorMessage());
        }
        return true;
    }

    private boolean isValidId(String id) {
        return !this.sequenceFilter(id) && !this.regexFilter(id, this.repeatingPattern) && !this.regexFilter(id, this.repeatingBlockPattern) && !this.validateNotStartWith(id) && !this.restrictedAdminFilter(id);
    }

    private boolean restrictedAdminFilter(String id) {
        return this.restrictedAdminDigits.parallelStream().anyMatch(id::contains);
    }

    private boolean sequenceFilter(String id) {
        if (this.sequenceLimit > 0) {
            return IntStream.rangeClosed(0, id.length() - this.sequenceLimit).parallel().mapToObj(index -> id.subSequence(index, index + this.sequenceLimit)).anyMatch(idSubSequence -> SEQ_ASC.contains((CharSequence)idSubSequence) || SEQ_DEC.contains((CharSequence)idSubSequence));
        }
        return false;
    }

    private boolean regexFilter(String id, Pattern pattern) {
        if (pattern != null) {
            return pattern.matcher(id).find();
        }
        return false;
    }

    private boolean validateNotStartWith(String id) {
        if (this.notStartWith != null && !this.notStartWith.isEmpty()) {
            for (String str : this.notStartWith) {
                if (!id.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }
}

