/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idvalidator.uin.impl;

import io.mosip.kernel.core.idvalidator.exception.InvalidIDException;
import io.mosip.kernel.core.idvalidator.spi.UinValidator;
import io.mosip.kernel.core.util.ChecksumUtils;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.idvalidator.uin.constant.UinExceptionConstant;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UinValidatorImpl
implements UinValidator<String> {
    @Value(value="${mosip.kernel.uin.length:-1}")
    private int uinLength;
    private String numaricRegEx;
    @Value(value="${mosip.kernel.uin.length.sequence-limit:-1}")
    private int sequenceLimit;
    @Value(value="${mosip.kernel.uin.length.repeating-block-limit:-1}")
    private int repeatingBlockLimit;
    @Value(value="${mosip.kernel.uin.length.repeating-limit:-1}")
    private int repeatingLimit;
    @Value(value="${mosip.kernel.uin.length.reverse-digits-limit:-1}")
    private int reverseLimit;
    @Value(value="${mosip.kernel.uin.length.digits-limit:-1}")
    private int limit;
    @Value(value="${mosip.kernel.uin.length.conjugative-even-digits-limit:-1}")
    private int conjugativeEvenDigitsLimit;
    @Value(value="#{'${mosip.kernel.uin.restricted-numbers}'.split(',')}")
    private List<String> restrictedAdminDigits;
    private static final String SEQ_ASC = "0123456789";
    private static final String SEQ_DEC = "9876543210";
    private Pattern repeatingPattern = null;
    private Pattern repeatingBlockPattern = null;
    private Pattern conjugativeEvenDigitsLimitPattern = null;
    private static final char CHAR_ZERO = '0';
    private static final char CHAR_ONE = '1';

    @PostConstruct
    private void uinValidatorImplnumaricRegEx() {
        this.numaricRegEx = "\\d{" + this.uinLength + "}";
        String repeatingRegEx = "(\\d)\\d{0," + (this.repeatingLimit - 1) + "}\\1";
        String repeatingBlockRegEx = "(\\d{" + this.repeatingBlockLimit + ",}).*?\\1";
        String conjugativeEvenDigitsLimitRegEx = "[2468]{" + this.conjugativeEvenDigitsLimit + "}";
        this.repeatingPattern = Pattern.compile(repeatingRegEx);
        this.repeatingBlockPattern = Pattern.compile(repeatingBlockRegEx);
        this.conjugativeEvenDigitsLimitPattern = Pattern.compile(conjugativeEvenDigitsLimitRegEx);
    }

    public boolean validateId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_INVALID_NULL.getErrorCode(), UinExceptionConstant.UIN_VAL_INVALID_NULL.getErrorMessage());
        }
        if (id.length() != this.uinLength) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_ILLEGAL_LENGTH.getErrorCode(), UinExceptionConstant.UIN_VAL_ILLEGAL_LENGTH.getErrorMessage());
        }
        if (!Pattern.matches(this.numaricRegEx, id)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_INVALID_DIGITS.getErrorCode(), UinExceptionConstant.UIN_VAL_INVALID_DIGITS.getErrorMessage());
        }
        if (id.charAt(0) == '0' || id.charAt(0) == '1') {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_INVALID_ZERO_ONE.getErrorCode(), UinExceptionConstant.UIN_VAL_INVALID_ZERO_ONE.getErrorMessage());
        }
        if (!this.isValidId(id)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_ILLEGAL_SEQUENCE_REPEATATIVE.getErrorCode(), UinExceptionConstant.UIN_VAL_ILLEGAL_SEQUENCE_REPEATATIVE.getErrorMessage());
        }
        if (!ChecksumUtils.validateChecksum((String)id)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_ILLEGAL_CHECKSUM.getErrorCode(), UinExceptionConstant.UIN_VAL_ILLEGAL_CHECKSUM.getErrorMessage());
        }
        if (this.firstAndLastDigitsReverseValidation(id, this.reverseLimit)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_ILLEGAL_REVERSE.getErrorCode(), UinExceptionConstant.UIN_VAL_ILLEGAL_REVERSE.getErrorMessage());
        }
        if (this.firstAndLastDigitsValidation(id, this.limit)) {
            throw new InvalidIDException(UinExceptionConstant.UIN_VAL_ILLEGAL_EQUAL_LIMIT.getErrorCode(), UinExceptionConstant.UIN_VAL_ILLEGAL_EQUAL_LIMIT.getErrorMessage());
        }
        return true;
    }

    private boolean isValidId(String id) {
        return !this.sequenceFilter(id) && !this.regexFilter(id, this.repeatingPattern) && !this.regexFilter(id, this.repeatingBlockPattern) && !this.regexFilter(id, this.conjugativeEvenDigitsLimitPattern) && !this.restrictedAdminFilter(id);
    }

    private boolean sequenceFilter(String id) {
        return IntStream.rangeClosed(0, id.length() - this.sequenceLimit).parallel().mapToObj(index -> id.subSequence(index, index + this.sequenceLimit)).anyMatch(idSubSequence -> SEQ_ASC.contains((CharSequence)idSubSequence) || SEQ_DEC.contains((CharSequence)idSubSequence));
    }

    private boolean regexFilter(String id, Pattern pattern) {
        return pattern.matcher(id).find();
    }

    private boolean firstAndLastDigitsReverseValidation(String id, int reverseLimit) {
        StringBuilder rev = new StringBuilder(id.substring(id.length() - reverseLimit, id.length()));
        rev = rev.reverse();
        return id.substring(0, reverseLimit).equals(rev.toString());
    }

    private boolean firstAndLastDigitsValidation(String id, int limit) {
        return id.substring(0, limit).equals(id.substring(id.length() - limit, id.length()));
    }

    private boolean restrictedAdminFilter(String id) {
        return this.restrictedAdminDigits.parallelStream().anyMatch(id::contains);
    }
}

