/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idvalidator.rid.impl;

import io.mosip.kernel.core.idvalidator.exception.InvalidIDException;
import io.mosip.kernel.core.idvalidator.spi.RidValidator;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.idvalidator.rid.constant.RidExceptionProperty;
import io.mosip.kernel.idvalidator.rid.constant.RidPropertyConstant;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RidValidatorImpl
implements RidValidator<String> {
    @Value(value="${mosip.kernel.rid.length:-1}")
    private int ridLength;
    @Value(value="${mosip.kernel.registrationcenterid.length:-1}")
    private int centerIdLength;
    @Value(value="${mosip.kernel.machineid.length:-1}")
    private int machineIdLength;
    @Value(value="${mosip.kernel.rid.timestamp-length:-1}")
    private int timeStampLength;
    @Value(value="${mosip.kernel.rid.sequence-length:-1}")
    private int sequenceLength;

    public boolean validateId(String id, String centerId, String machineId) {
        this.validateAllInputs(id, centerId, machineId, this.centerIdLength, this.machineIdLength, this.sequenceLength, this.timeStampLength);
        return true;
    }

    public boolean validateId(String id) {
        this.validateInputs(id, this.centerIdLength, this.machineIdLength, this.sequenceLength, this.timeStampLength);
        return true;
    }

    public boolean validateId(String id, String centerId, String machineId, int centerIdLength, int machineIdLength, int sequenceLength, int timeStampLength) {
        this.validateAllInputs(id, centerId, machineId, centerIdLength, machineIdLength, sequenceLength, timeStampLength);
        return true;
    }

    public boolean validateId(String id, int centerIdLength, int machineIdLength, int sequenceLength, int timeStampLength) {
        this.validateInputs(id, centerIdLength, machineIdLength, sequenceLength, timeStampLength);
        return true;
    }

    private void validateAllInputs(String id, String centerId, String machineId, int centerIdLength, int machineIdLength, int sequenceLength, int timeStampLength) {
        this.validateInputs(id, centerIdLength, machineIdLength, sequenceLength, timeStampLength);
        int endIndex = centerIdLength + machineIdLength;
        if (!id.substring(0, centerIdLength).equals(centerId)) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_CENTER_ID.getErrorCode(), RidExceptionProperty.INVALID_CENTER_ID.getErrorMessage());
        }
        if (!id.substring(centerIdLength, endIndex).equals(machineId)) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_MACHINE_ID.getErrorCode(), RidExceptionProperty.INVALID_MACHINE_ID.getErrorMessage());
        }
    }

    private void validateInputs(String id, int centerIdLength, int machineIdLength, int sequenceLength, int timeStampLength) {
        String pattern = RidPropertyConstant.TIME_STAMP_REGEX.getProperty();
        int sequenceStartIndex = centerIdLength + machineIdLength;
        int sequenceEndIndex = id.length() - timeStampLength;
        int timeStampStartIndex = id.length() - timeStampLength;
        int timeStampEndIndex = id.length();
        if (this.ridLength <= 0 || centerIdLength <= 0 || machineIdLength <= 0 || sequenceLength <= 0 || timeStampLength <= 0) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_RIDLENGTH_OR_CENTERIDLENGTH_MACHINEIDLENGTH_TIMESTAMPLENGTH.getErrorCode(), RidExceptionProperty.INVALID_RIDLENGTH_OR_CENTERIDLENGTH_MACHINEIDLENGTH_TIMESTAMPLENGTH.getErrorMessage());
        }
        if (id.length() != this.ridLength) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_RID_LENGTH.getErrorCode(), RidExceptionProperty.INVALID_RID_LENGTH.getErrorMessage() + " :" + this.ridLength);
        }
        if (!StringUtils.isNumeric((CharSequence)id)) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_RID.getErrorCode(), RidExceptionProperty.INVALID_RID.getErrorMessage());
        }
        if (!Pattern.matches(pattern, id.subSequence(timeStampStartIndex, timeStampEndIndex))) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_RID_TIMESTAMP.getErrorCode(), RidExceptionProperty.INVALID_RID_TIMESTAMP.getErrorMessage());
        }
        if (id.substring(sequenceStartIndex, sequenceEndIndex).length() != sequenceLength) {
            throw new InvalidIDException(RidExceptionProperty.INVALID_RID_SEQ_LENGTH.getErrorCode(), RidExceptionProperty.INVALID_RID_SEQ_LENGTH.getErrorMessage());
        }
    }
}

