/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idvalidator.mispid.impl;

import io.mosip.kernel.core.idvalidator.exception.InvalidIDException;
import io.mosip.kernel.core.idvalidator.spi.IdValidator;
import io.mosip.kernel.idvalidator.mispid.constant.MispIdExceptionProperty;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MispIdValidatorImpl
implements IdValidator<String> {
    @Value(value="${mosip.kernel.mispid.length}")
    private int mispidLength;

    public boolean validateId(String id) {
        if (id == null || id.trim().isEmpty()) {
            throw new InvalidIDException(MispIdExceptionProperty.INVALID_MISPID.getErrorCode(), MispIdExceptionProperty.INVALID_MISPID.getErrorMessage());
        }
        if (id.length() != this.mispidLength) {
            throw new InvalidIDException(MispIdExceptionProperty.INVALID_MISPID_LENGTH.getErrorCode(), MispIdExceptionProperty.INVALID_MISPID_LENGTH.getErrorMessage() + this.mispidLength);
        }
        return true;
    }
}

