/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public class ValidatorsKeywordValidator
extends AbstractKeywordValidator {
    public ValidatorsKeywordValidator(JsonNode digest) {
        super("validators");
    }

    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode schema = data.getSchema().getNode();
        if (schema.hasNonNull("validators")) {
            JsonNode validators = schema.get("validators");
            for (int i = 0; i < validators.size(); ++i) {
                JsonNode validator = validators.get(i);
                if (this.isValid(validator, data.getInstance().getNode().asText())) continue;
                report.error(this.newMsg(data, bundle, "incorrectMatch").put("matcher", validator).put("provided", data.getInstance().getNode()));
            }
        }
    }

    public String toString() {
        return null;
    }

    private boolean isValid(JsonNode validator, CharSequence data) {
        String type;
        switch (type = validator.get("type").asText()) {
            case "regex": {
                Pattern pattern = Pattern.compile(validator.get("validator").asText());
                return pattern.matcher(data).matches();
            }
        }
        return true;
    }
}

