/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorErrorConstant;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectIOException;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectValidationFailedException;
import io.mosip.kernel.core.idobjectvalidator.exception.InvalidIdSchemaException;
import io.mosip.kernel.core.idobjectvalidator.spi.IdObjectValidator;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.idobjectvalidator.helper.IdObjectValidatorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component(value="schema")
@RefreshScope
public class IdObjectSchemaValidator
implements IdObjectValidator {
    private static final Logger logger = LoggerFactory.getLogger(IdObjectSchemaValidator.class);
    @Autowired
    private ObjectMapper mapper;
    private static final String MISSING = "missing";
    private static final String UNWANTED = "unwanted";

    public boolean validateIdObject(String identitySchema, Object identityObject, List<String> requiredFields) throws IdObjectValidationFailedException, IdObjectIOException, InvalidIdSchemaException {
        try {
            JsonSchema jsonSchema = this.getJsonSchema(identitySchema);
            JsonNode jsonIdObjectNode = this.mapper.readTree(this.mapper.writeValueAsString(identityObject));
            ProcessingReport report = jsonSchema.validate(jsonIdObjectNode);
            logger.debug("schema validation report generated : " + report);
            List<ServiceError> errorList = this.getErrorList(report, requiredFields);
            if (!errorList.isEmpty()) {
                logger.error("IdObject Validation Failed with errors : " + errorList);
                throw new IdObjectValidationFailedException(IdObjectValidatorErrorConstant.ID_OBJECT_VALIDATION_FAILED, errorList);
            }
            return true;
        }
        catch (IOException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION, (Throwable)e);
        }
        catch (ProcessingException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.ID_OBJECT_VALIDATION_FAILED, (Throwable)e);
        }
    }

    private JsonSchema getJsonSchema(String schemaJson) throws InvalidIdSchemaException {
        try {
            if (schemaJson == null) {
                throw new InvalidIdSchemaException(IdObjectValidatorErrorConstant.INVALID_ID_SCHEMA.getErrorCode(), IdObjectValidatorErrorConstant.INVALID_ID_SCHEMA.getMessage());
            }
            JSONObject schema = new JSONObject(schemaJson);
            JsonNode jsonIdSchemaNode = JsonLoader.fromString((String)schema.toString());
            if (jsonIdSchemaNode.size() <= 0 || !jsonIdSchemaNode.hasNonNull("$schema") || !jsonIdSchemaNode.hasNonNull("type")) {
                throw new InvalidIdSchemaException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getErrorCode(), IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getMessage());
            }
            JsonSchemaFactory factory = IdObjectValidatorHelper.getJSONSchemaFactory();
            return factory.getJsonSchema(jsonIdSchemaNode);
        }
        catch (ProcessingException | IOException | JSONException e) {
            throw new InvalidIdSchemaException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getErrorCode(), IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getMessage());
        }
    }

    private List<ServiceError> getErrorList(ProcessingReport report, List<String> requiredFields) {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        if (!report.isSuccess()) {
            report.forEach(processingMessage -> {
                JsonNode processingMessageAsJson;
                if (processingMessage.getLogLevel().toString().equals("error") && (processingMessageAsJson = processingMessage.asJson()).hasNonNull("instance") && processingMessageAsJson.get("instance").hasNonNull("pointer")) {
                    if (processingMessageAsJson.has(MISSING) && !processingMessageAsJson.get(MISSING).isNull()) {
                        this.buildErrorMessages(errorList, processingMessageAsJson, IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER, MISSING, requiredFields);
                    } else {
                        this.buildErrorMessages(errorList, processingMessageAsJson, IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER, UNWANTED, null);
                    }
                    if (processingMessageAsJson.hasNonNull("keyword") && processingMessageAsJson.get("keyword").asText().contentEquals("validators")) {
                        this.buildErrorMessages(errorList, processingMessageAsJson, IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER, "keyword", null);
                    }
                }
            });
        }
        return errorList;
    }

    private void buildErrorMessages(List<ServiceError> errorList, JsonNode processingMessageAsJson, IdObjectValidatorErrorConstant errorConstant, String field, List<String> requiredFields) {
        if (processingMessageAsJson.hasNonNull(field)) {
            if (field.contentEquals("keyword")) {
                errorList.add(new ServiceError(errorConstant.getErrorCode(), String.format(errorConstant.getMessage(), StringUtils.strip((String)processingMessageAsJson.get("instance").get("pointer").asText(), (String)"/"))));
            } else {
                StreamSupport.stream(((ArrayNode)processingMessageAsJson.get(field)).spliterator(), false).filter(element -> {
                    if (Objects.isNull(requiredFields)) {
                        return true;
                    }
                    return requiredFields.contains(element.asText());
                }).forEach(element -> errorList.add(new ServiceError(errorConstant.getErrorCode(), String.format(errorConstant.getMessage(), StringUtils.strip((String)(processingMessageAsJson.get("instance").get("pointer").asText() + "/" + element.asText()), (String)"/")))));
            }
        }
    }
}

