/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.helper;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.msgsimple.source.MapMessageSource;
import com.github.fge.msgsimple.source.MessageSource;
import io.mosip.kernel.idobjectvalidator.helper.DummySyntaxChecker;
import io.mosip.kernel.idobjectvalidator.helper.LowerCasedFormatAttribute;
import io.mosip.kernel.idobjectvalidator.helper.UpperCasedFormatAttribute;
import io.mosip.kernel.idobjectvalidator.helper.ValidatorsKeywordValidator;

public class IdObjectValidatorHelper {
    private static final String URI = "http://json-schema.org/draft-07/schema#";
    private static JsonSchemaFactory jsonFactory = null;

    public static JsonSchemaFactory getJSONSchemaFactory() {
        if (jsonFactory != null) {
            return jsonFactory;
        }
        Keyword fieldType = Keyword.newBuilder((String)"fieldType").withSyntaxChecker((SyntaxChecker)new DummySyntaxChecker("fieldType", NodeType.STRING)).withSimpleDigester(NodeType.STRING, NodeType.values()).freeze();
        Keyword fieldCategory = Keyword.newBuilder((String)"fieldCategory").withSyntaxChecker((SyntaxChecker)new DummySyntaxChecker("fieldCategory", NodeType.STRING)).withSimpleDigester(NodeType.STRING, NodeType.values()).freeze();
        Keyword bioAttributesKeyword = Keyword.newBuilder((String)"bioAttributes").withSyntaxChecker((SyntaxChecker)new DummySyntaxChecker("bioAttributes", NodeType.ARRAY)).withSimpleDigester(NodeType.ARRAY, NodeType.values()).freeze();
        Keyword validatorsKeyword = Keyword.newBuilder((String)"validators").withSyntaxChecker((SyntaxChecker)new DummySyntaxChecker("validators", NodeType.ARRAY)).withSimpleDigester(NodeType.ARRAY, NodeType.values()).withValidatorClass(ValidatorsKeywordValidator.class).freeze();
        MessageSource source = MapMessageSource.newBuilder().put("incorrectCase", "Input value is not in correct case").build();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(source).freeze();
        Library library = DraftV4Library.get().thaw().addKeyword(fieldType).addKeyword(fieldCategory).addKeyword(validatorsKeyword).addKeyword(bioAttributesKeyword).addFormatAttribute("lowercased", LowerCasedFormatAttribute.getInstance()).addFormatAttribute("uppercased", UpperCasedFormatAttribute.getInstance()).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary(URI, library).setValidationMessages(bundle).freeze();
        jsonFactory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        return jsonFactory;
    }
}

