/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.impl;

import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorSupportedOperations;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectIOException;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectValidationFailedException;
import io.mosip.kernel.core.idobjectvalidator.spi.IdObjectValidator;
import io.mosip.kernel.idobjectvalidator.impl.IdObjectPatternValidator;
import io.mosip.kernel.idobjectvalidator.impl.IdObjectSchemaValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class IdObjectCompositeValidator
implements IdObjectValidator {
    @Autowired
    private IdObjectSchemaValidator schemaValidator;
    @Autowired
    private IdObjectPatternValidator patternValidator;
    @Autowired(required=false)
    @Qualifier(value="referenceValidator")
    @Lazy
    private IdObjectValidator referenceValidator;

    public boolean validateIdObject(Object identityObject, IdObjectValidatorSupportedOperations operation) throws IdObjectValidationFailedException, IdObjectIOException {
        this.schemaValidator.validateIdObject(identityObject, operation);
        this.patternValidator.validateIdObject(identityObject, operation);
        this.referenceValidator.validateIdObject(identityObject, operation);
        return true;
    }
}

