/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.config;

import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorSupportedOperations;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectIOException;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectValidationFailedException;
import io.mosip.kernel.core.idobjectvalidator.spi.IdObjectValidator;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration
public class IdObjectValidatorConfig {
    private static final Logger logger = LoggerFactory.getLogger(IdObjectValidatorConfig.class);
    @Autowired
    private Environment env;

    @PostConstruct
    public void validateReferenceValidator() throws ClassNotFoundException {
        if (StringUtils.isNotBlank((CharSequence)this.env.getProperty("mosip.kernel.idobjectvalidator.referenceValidator"))) {
            logger.debug("validating referenceValidator Class is present or not");
            Class.forName(this.env.getProperty("mosip.kernel.idobjectvalidator.referenceValidator"));
        }
        logger.debug("validateReferenceValidator: referenceValidator Class is not provided");
    }

    @Bean
    @Lazy
    public IdObjectValidator referenceValidator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (StringUtils.isNotBlank((CharSequence)this.env.getProperty("mosip.kernel.idobjectvalidator.referenceValidator"))) {
            logger.debug("instance of referenceValidator is created");
            return (IdObjectValidator)Class.forName(this.env.getProperty("mosip.kernel.idobjectvalidator.referenceValidator")).newInstance();
        }
        logger.debug("no reference validator is provided");
        return new IdObjectValidator(){

            public boolean validateIdObject(Object arg0, IdObjectValidatorSupportedOperations arg1) throws IdObjectValidationFailedException, IdObjectIOException {
                return true;
            }
        };
    }
}

