/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorErrorConstant;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorPropertySourceConstant;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorSupportedOperations;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectIOException;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectValidationFailedException;
import io.mosip.kernel.core.idobjectvalidator.spi.IdObjectValidator;
import io.mosip.kernel.core.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="schema")
@RefreshScope
public class IdObjectSchemaValidator
implements IdObjectValidator {
    private static final Logger logger = LoggerFactory.getLogger(IdObjectSchemaValidator.class);
    private static final String OPERATION = "operation";
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private Environment env;
    private static final String MISSING = "missing";
    private static final String UNWANTED = "unwanted";
    @Value(value="${mosip.kernel.idobjectvalidator.file-storage-uri}")
    private String configServerFileStorageURL;
    @Value(value="${mosip.kernel.idobjectvalidator.schema-name}")
    private String schemaName;
    @Value(value="${mosip.kernel.idobjectvalidator.property-source}")
    private String propertySource;
    private JsonNode schema;

    @PostConstruct
    public void loadSchema() throws IdObjectIOException {
        try {
            if (IdObjectValidatorPropertySourceConstant.APPLICATION_CONTEXT.getPropertySource().equals(this.propertySource)) {
                logger.debug("schema loaded from application context");
                this.schema = JsonLoader.fromURL((URL)new URL(this.configServerFileStorageURL + this.schemaName));
            }
        }
        catch (IOException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION, (Throwable)e);
        }
    }

    public boolean validateIdObject(Object idObject, IdObjectValidatorSupportedOperations operation) throws IdObjectValidationFailedException, IdObjectIOException {
        JsonNode jsonObjectNode = null;
        JsonNode jsonSchemaNode = null;
        ProcessingReport report = null;
        try {
            jsonObjectNode = this.mapper.readTree(this.mapper.writeValueAsString(idObject));
            jsonSchemaNode = this.getJsonSchemaNode();
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonSchema jsonSchema = factory.getJsonSchema(jsonSchemaNode);
            report = jsonSchema.validate(jsonObjectNode);
            logger.debug("schema validation report generated : " + report);
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            if (!report.isSuccess()) {
                report.forEach(processingMessage -> {
                    JsonNode processingMessageAsJson;
                    if (processingMessage.getLogLevel().toString().equals("error") && (processingMessageAsJson = processingMessage.asJson()).hasNonNull("instance") && processingMessageAsJson.get("instance").hasNonNull("pointer")) {
                        if (processingMessageAsJson.has(MISSING) && !processingMessageAsJson.get(MISSING).isNull()) {
                            errorList.add(new ServiceError(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getErrorCode(), this.buildErrorMessage(processingMessageAsJson, IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getMessage(), MISSING)));
                        } else {
                            errorList.add(new ServiceError(IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getErrorCode(), this.buildErrorMessage(processingMessageAsJson, IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getMessage(), UNWANTED)));
                        }
                    }
                });
            }
            this.validateMandatoryFields(jsonObjectNode, operation, errorList);
            if (!errorList.isEmpty()) {
                logger.debug("IdObjectValidationFailedException thrown with errors : " + errorList);
                throw new IdObjectValidationFailedException(IdObjectValidatorErrorConstant.ID_OBJECT_VALIDATION_FAILED, errorList);
            }
            return true;
        }
        catch (IOException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.ID_OBJECT_PARSING_FAILED, (Throwable)e);
        }
        catch (ProcessingException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.ID_OBJECT_VALIDATION_FAILED, (Throwable)e);
        }
    }

    private void validateMandatoryFields(JsonNode jsonObjectNode, IdObjectValidatorSupportedOperations operation, List<ServiceError> errorList) throws IdObjectIOException {
        if (Objects.isNull(operation)) {
            logger.debug("mandatory field input operation is null");
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getErrorCode(), String.format(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getMessage(), OPERATION));
        }
        String appId = this.env.getProperty("application.id");
        if (Objects.isNull(appId)) {
            logger.debug("mandatory field input appId is null");
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getErrorCode(), String.format(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getMessage(), "application.id"));
        }
        String fields = this.env.getProperty(String.format("mosip.kernel.idobjectvalidator.mandatory-attributes.%s.%s", appId, operation.getOperation()));
        Optional.ofNullable(fields).ifPresent(fieldList -> Arrays.asList(StringUtils.split((String)fields, (char)',')).parallelStream().map(StringUtils::normalizeSpace).forEach(field -> {
            List<String> fieldNames = Arrays.asList(field.split("\\|"));
            fieldNames = fieldNames.stream().map(fieldName -> "/".concat("identity".concat("/".concat(fieldName.replace('.', '/'))))).collect(Collectors.toList());
            this.validateMissingFields(jsonObjectNode, errorList, fieldNames);
            this.validateInvalidFields(jsonObjectNode, errorList, fieldNames);
        }));
    }

    private void validateMissingFields(JsonNode jsonObjectNode, List<ServiceError> errorList, List<String> fieldNames) {
        if (fieldNames.parallelStream().allMatch(fieldName -> this.isMissingOrEmpty(jsonObjectNode, (String)fieldName))) {
            errorList.add(new ServiceError(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getErrorCode(), String.format(IdObjectValidatorErrorConstant.MISSING_INPUT_PARAMETER.getMessage(), fieldNames.parallelStream().map(fieldName -> fieldName.replaceFirst("/", "")).collect(Collectors.joining(" | ")))));
        }
    }

    private void validateInvalidFields(JsonNode jsonObjectNode, List<ServiceError> errorList, List<String> fieldNames) {
        if (fieldNames.parallelStream().anyMatch(fieldName -> !this.isMissingOrEmpty(jsonObjectNode, (String)fieldName) && (jsonObjectNode.at(fieldName).isArray() ? jsonObjectNode.findValuesAsText("value").stream().allMatch(StringUtils::isBlank) : StringUtils.isBlank((CharSequence)jsonObjectNode.at(fieldName).toString())))) {
            errorList.add(new ServiceError(IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getErrorCode(), String.format(IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getMessage(), fieldNames.parallelStream().map(fieldName -> fieldName.replaceFirst("/", "")).collect(Collectors.joining(" | ")))));
        }
    }

    private boolean isMissingOrEmpty(JsonNode jsonObjectNode, String fieldName) {
        return jsonObjectNode.at(fieldName).isMissingNode() || StringUtils.isEmpty((CharSequence)jsonObjectNode.at(fieldName).toString());
    }

    private String buildErrorMessage(JsonNode processingMessageAsJson, String messageBody, String field) {
        return String.format(messageBody, StringUtils.strip((String)(processingMessageAsJson.get("instance").get("pointer").asText() + (processingMessageAsJson.hasNonNull(field) ? "/" + StringUtils.removeAll((String)processingMessageAsJson.get(field).toString(), (String)"[\\[\"\\]]") : "")), (String)"/"));
    }

    private JsonNode getJsonSchemaNode() throws IdObjectIOException {
        logger.debug("propertySource is set to " + this.propertySource);
        JsonNode jsonSchemaNode = null;
        if (IdObjectValidatorPropertySourceConstant.CONFIG_SERVER.getPropertySource().equals(this.propertySource)) {
            try {
                jsonSchemaNode = JsonLoader.fromURL((URL)new URL(this.configServerFileStorageURL + this.schemaName));
                logger.debug("schema is loaded from config server");
            }
            catch (IOException e) {
                ExceptionUtils.logRootCause((Throwable)e);
                throw new IdObjectIOException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION, (Throwable)e);
            }
        } else if (IdObjectValidatorPropertySourceConstant.LOCAL.getPropertySource().equals(this.propertySource)) {
            try {
                jsonSchemaNode = JsonLoader.fromResource((String)("/" + this.schemaName));
                logger.debug("schema is loaded from LOCAL");
            }
            catch (IOException e) {
                ExceptionUtils.logRootCause((Throwable)e);
                throw new IdObjectIOException(IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getErrorCode(), IdObjectValidatorErrorConstant.SCHEMA_IO_EXCEPTION.getMessage(), e.getCause());
            }
        } else if (IdObjectValidatorPropertySourceConstant.APPLICATION_CONTEXT.getPropertySource().equals(this.propertySource)) {
            jsonSchemaNode = this.schema;
            logger.debug("schema is loaded from APPLICATION_CONTEXT");
        }
        return jsonSchemaNode;
    }
}

