/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idobjectvalidator.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorErrorConstant;
import io.mosip.kernel.core.idobjectvalidator.constant.IdObjectValidatorSupportedOperations;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectIOException;
import io.mosip.kernel.core.idobjectvalidator.exception.IdObjectValidationFailedException;
import io.mosip.kernel.core.idobjectvalidator.spi.IdObjectValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minidev.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component(value="pattern")
@ConfigurationProperties(value="mosip.id")
public class IdObjectPatternValidator
implements IdObjectValidator {
    @Autowired
    private ObjectMapper mapper;
    private Map<String, String> validation;

    public void setValidation(Map<String, String> validation) {
        this.validation = validation;
    }

    public boolean validateIdObject(Object identityObject, IdObjectValidatorSupportedOperations operation) throws IdObjectIOException, IdObjectValidationFailedException {
        try {
            String identityString = this.mapper.writeValueAsString(identityObject);
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            this.validateAttributes(identityString, errorList);
            if (errorList.isEmpty()) {
                return true;
            }
            throw new IdObjectValidationFailedException(IdObjectValidatorErrorConstant.ID_OBJECT_VALIDATION_FAILED, errorList);
        }
        catch (JsonProcessingException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            throw new IdObjectIOException(IdObjectValidatorErrorConstant.ID_OBJECT_PARSING_FAILED, (Throwable)e);
        }
    }

    private void validateAttributes(String identity, List<ServiceError> errorList) {
        this.validation.entrySet().parallelStream().forEach(entry -> {
            JsonPath jsonPath = JsonPath.compile((String)((String)entry.getKey()), (Predicate[])new Predicate[0]);
            Pattern pattern = Pattern.compile((String)entry.getValue());
            JSONArray data = (JSONArray)jsonPath.read(identity, Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}));
            if (Objects.nonNull(data) && !data.isEmpty()) {
                IntStream.range(0, data.size()).parallel().filter(index -> !pattern.matcher(String.valueOf(data.get(index))).matches()).forEach(index -> {
                    JSONArray pathList = (JSONArray)jsonPath.read(identity, Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST, Option.AS_PATH_LIST}));
                    errorList.add(new ServiceError(IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getErrorCode(), String.format(IdObjectValidatorErrorConstant.INVALID_INPUT_PARAMETER.getMessage(), this.convertToPath(String.valueOf(pathList.get(index))))));
                });
            }
        });
    }

    private String convertToPath(String jsonPath) {
        String path = String.valueOf(jsonPath.replaceAll("[$']", ""));
        return path.substring(1, path.length() - 1).replace("][", "/");
    }
}

