/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.vid.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.idgenerator.spi.VidGenerator;
import io.mosip.kernel.core.util.ChecksumUtils;
import io.mosip.kernel.idgenerator.vid.constant.VidPropertyConstant;
import io.mosip.kernel.idgenerator.vid.util.VidFilterUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.PostConstruct;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VidGeneratorImpl
implements VidGenerator<String> {
    boolean init = true;
    private String randomSeed;
    private String counter;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    VidFilterUtils vidFilterUtils;
    @Value(value="${mosip.kernel.vid.length}")
    private int vidLength;

    @PostConstruct
    private void init() {
        this.randomSeed = RandomStringUtils.random((int)Integer.parseInt(VidPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)VidPropertyConstant.ZERO_TO_NINE.getProperty());
        do {
            this.counter = RandomStringUtils.random((int)Integer.parseInt(VidPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)VidPropertyConstant.ZERO_TO_NINE.getProperty());
        } while (this.counter.charAt(0) == '0');
    }

    public String generateId() {
        String generatedVid = this.generateRandomId();
        while (!this.vidFilterUtils.isValidId(generatedVid) || generatedVid.contains(" ")) {
            generatedVid = this.generateRandomId();
        }
        return generatedVid;
    }

    private String generateRandomId() {
        String vid = null;
        this.counter = this.init ? this.counter : new BigInteger(this.counter).add(BigInteger.ONE).toString();
        this.init = false;
        SecretKeySpec secretKey = new SecretKeySpec(this.counter.getBytes(), VidPropertyConstant.ENCRYPTION_ALGORITHM.getProperty());
        byte[] encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)this.randomSeed.getBytes(), null);
        BigInteger bigInteger = new BigInteger(encryptedData);
        vid = String.valueOf(bigInteger.abs());
        vid = vid.substring(0, this.vidLength - 1);
        String verhoeffDigit = ChecksumUtils.generateChecksumDigit((String)vid);
        return this.appendChecksum(vid, verhoeffDigit);
    }

    private String appendChecksum(String generatedVId, String verhoeffDigit) {
        StringBuilder vidSb = new StringBuilder();
        vidSb.setLength(this.vidLength);
        return vidSb.insert(0, generatedVId).insert(generatedVId.length(), verhoeffDigit).toString().trim();
    }
}

