/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.tokenid.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.dataaccess.exception.DataAccessLayerException;
import io.mosip.kernel.core.idgenerator.spi.TokenIdGenerator;
import io.mosip.kernel.idgenerator.tokenid.constant.TokenIDExceptionConstant;
import io.mosip.kernel.idgenerator.tokenid.constant.TokenIdPropertyConstant;
import io.mosip.kernel.idgenerator.tokenid.entity.TokenIdSeed;
import io.mosip.kernel.idgenerator.tokenid.entity.TokenIdSequence;
import io.mosip.kernel.idgenerator.tokenid.exception.TokenIdGeneratorException;
import io.mosip.kernel.idgenerator.tokenid.repository.TokenIdSeedRepository;
import io.mosip.kernel.idgenerator.tokenid.repository.TokenIdSequenceRepository;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.PersistenceException;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TokenIdGeneratorImpl
implements TokenIdGenerator<String> {
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    private TokenIdSeedRepository seedRepository;
    @Autowired
    private TokenIdSequenceRepository sequenceRepository;
    @Value(value="${mosip.kernel.tokenid.length}")
    private Integer tokenIdLength;

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public String generateId() {
        String counterSecureRandom = null;
        String randomSeed = null;
        String tokenId = null;
        List listOfSeed = null;
        TokenIdSequence sequenceEntity = null;
        try {
            listOfSeed = this.seedRepository.findAll();
            sequenceEntity = this.sequenceRepository.findMaxSequence();
        }
        catch (DataAccessLayerException | DataAccessException e) {
            throw new TokenIdGeneratorException(TokenIDExceptionConstant.TOKENID_FETCH_EXCEPTION.getErrorCode(), TokenIDExceptionConstant.TOKENID_FETCH_EXCEPTION.getErrorMessage(), e);
        }
        try {
            TokenIdSequence counterEntity = new TokenIdSequence();
            counterEntity.setCreatedBy("SYSTEM");
            counterEntity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
            counterEntity.setDeletedDateTime(null);
            counterEntity.setIsDeleted(false);
            if (sequenceEntity == null) {
                while ((counterSecureRandom = RandomStringUtils.random((int)Integer.parseInt(TokenIdPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)TokenIdPropertyConstant.ZERO_TO_NINE.getProperty())).charAt(0) == '0') {
                }
                counterEntity.setSequenceNumber(counterSecureRandom);
            } else {
                counterSecureRandom = sequenceEntity.getSequenceNumber();
                counterSecureRandom = new BigInteger(counterSecureRandom).add(BigInteger.ONE).toString();
                counterEntity.setSequenceNumber(counterSecureRandom);
            }
            this.sequenceRepository.saveAndFlush(counterEntity);
            if (listOfSeed.isEmpty()) {
                randomSeed = RandomStringUtils.random((int)Integer.parseInt(TokenIdPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)TokenIdPropertyConstant.ZERO_TO_NINE.getProperty());
                TokenIdSeed seedEntity = new TokenIdSeed();
                seedEntity.setCreatedBy("SYSTEM");
                seedEntity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                seedEntity.setDeletedDateTime(null);
                seedEntity.setIsDeleted(false);
                seedEntity.setSeedNumber(randomSeed);
                this.seedRepository.saveAndFlush(seedEntity);
            } else {
                randomSeed = ((TokenIdSeed)listOfSeed.get(0)).getSeedNumber();
            }
            SecretKeySpec secretKey = new SecretKeySpec(counterSecureRandom.getBytes(), TokenIdPropertyConstant.ENCRYPTION_ALGORITHM.getProperty());
            byte[] encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)randomSeed.getBytes(), null);
            BigInteger bigInteger = new BigInteger(encryptedData);
            tokenId = String.valueOf(bigInteger.abs());
        }
        catch (DataAccessLayerException | DataAccessException e) {
            if (e.getCause().getClass() == PersistenceException.class) {
                return this.generateId();
            }
            throw new TokenIdGeneratorException(TokenIDExceptionConstant.TOKENID_INSERTION_EXCEPTION.getErrorCode(), TokenIDExceptionConstant.TOKENID_INSERTION_EXCEPTION.getErrorMessage(), e);
        }
        return tokenId.substring(0, this.tokenIdLength);
    }
}

