/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.service.impl;

import io.mosip.kernel.core.authmanager.authadapter.spi.VertxAuthenticationProvider;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.vidgenerator.constant.VIDGeneratorErrorCode;
import io.mosip.kernel.vidgenerator.dto.VidFetchResponseDto;
import io.mosip.kernel.vidgenerator.entity.BaseEntity;
import io.mosip.kernel.vidgenerator.entity.VidAssignedEntity;
import io.mosip.kernel.vidgenerator.entity.VidEntity;
import io.mosip.kernel.vidgenerator.exception.VidGeneratorServiceException;
import io.mosip.kernel.vidgenerator.repository.VidAssignedRepository;
import io.mosip.kernel.vidgenerator.repository.VidRepository;
import io.mosip.kernel.vidgenerator.service.VidService;
import io.mosip.kernel.vidgenerator.utils.ExceptionUtils;
import io.mosip.kernel.vidgenerator.utils.VIDMetaDataUtil;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VidServiceImpl
implements VidService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VidServiceImpl.class);
    @Value(value="${mosip.kernel.vid.time-to-release-after-expiry}")
    private long timeToRelaseAfterExpiry;
    @Autowired
    private VidRepository vidRepository;
    @Autowired
    private VidAssignedRepository vidAssignedRepository;
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private VIDMetaDataUtil metaDataUtil;
    @Autowired
    private VertxAuthenticationProvider authHandler;

    @Transactional
    public VidFetchResponseDto fetchVid(LocalDateTime vidExpiry, RoutingContext routingContext) {
        VidFetchResponseDto vidFetchResponseDto = new VidFetchResponseDto();
        VidEntity vidEntity = null;
        try {
            vidEntity = this.vidRepository.findFirstByStatus("AVAILABLE");
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
        }
        if (vidEntity != null) {
            if (vidExpiry != null) {
                vidEntity.setVidExpiry(vidExpiry);
            }
            vidFetchResponseDto.setVid(vidEntity.getVid());
            try {
                this.vidRepository.updateVid("ASSIGNED", this.authHandler.getContextUser(routingContext), DateUtils.getUTCCurrentDateTime(), vidEntity.getVid());
            }
            catch (DataAccessException exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
            }
            catch (Exception exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
            }
        } else {
            LOGGER.info((Object)"vid not available");
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.VID_NOT_AVAILABLE.getErrorCode(), VIDGeneratorErrorCode.VID_NOT_AVAILABLE.getErrorMessage());
        }
        return vidFetchResponseDto;
    }

    public long fetchVidCount(String status) {
        long vidCount = 0L;
        try {
            vidCount = this.vidRepository.countByStatusAndIsDeletedFalse(status);
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        return vidCount;
    }

    public void expireAndRelease() {
        try {
            this.expireEligibleVids();
            this.releaseEligibleVids();
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
    }

    private void expireEligibleVids() {
        List vidAssignedEntities = this.vidAssignedRepository.findByStatusAndIsDeletedFalse("ASSIGNED");
        vidAssignedEntities.forEach(arg_0 -> this.expireIfEligible(arg_0));
        this.vidAssignedRepository.saveAll((Iterable)vidAssignedEntities);
    }

    private void releaseEligibleVids() {
        List vidExpiredEntities = this.vidAssignedRepository.findByStatusAndIsDeletedFalse("EXPIRED");
        ArrayList releasableVidAssignedEntities = new ArrayList();
        vidExpiredEntities.forEach(entity -> {
            if (this.isEligibleToRelease(entity)) {
                releasableVidAssignedEntities.add(entity);
            }
        });
        if (releasableVidAssignedEntities.size() > 0) {
            this.vidAssignedRepository.deleteAll(releasableVidAssignedEntities);
        }
    }

    private void expireIfEligible(VidAssignedEntity entity) {
        LocalDateTime currentTime = DateUtils.getUTCCurrentDateTime();
        LOGGER.debug((Object)"currenttime {} for checking entity with expiry time {}", new Object[]{currentTime, entity.getVidExpiry()});
        if (entity.getVidExpiry() != null && (entity.getVidExpiry().isBefore(currentTime) || entity.getVidExpiry().isEqual(currentTime)) && entity.getStatus().equals("ASSIGNED")) {
            this.metaDataUtil.setUpdateMetaData((BaseEntity)entity);
            entity.setStatus("EXPIRED");
        }
    }

    private boolean isEligibleToRelease(VidAssignedEntity entity) {
        LocalDateTime currentTime = DateUtils.getUTCCurrentDateTime();
        LocalDateTime releaseElegibleTime = entity.getVidExpiry().plusDays(this.timeToRelaseAfterExpiry);
        LOGGER.debug((Object)"currenttime {} for checking entity with release elegible time {}", new Object[]{currentTime, releaseElegibleTime});
        return (releaseElegibleTime.isBefore(currentTime) || releaseElegibleTime.isEqual(currentTime)) && entity.getStatus().equals("EXPIRED");
    }

    public boolean saveVID(VidEntity vid) {
        if (!this.vidRepository.existsById((Object)vid.getVid()) && !this.vidAssignedRepository.existsById((Object)vid.getVid())) {
            try {
                this.vidRepository.saveAndFlush((Object)vid);
            }
            catch (DataAccessException exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                return false;
            }
            catch (Exception exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                return false;
            }
            return true;
        }
        return false;
    }

    @Transactional(transactionManager="transactionManager")
    public void isolateAssignedVids() {
        List vidEntities = this.vidRepository.findByStatusAndIsDeletedFalse("ASSIGNED");
        LOGGER.info((Object)"isolateAssignedVids called for entity count {} ", new Object[]{vidEntities.size()});
        List vidEntitiesAssined = (List)this.modelMapper.map((Object)vidEntities, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.vidAssignedRepository.saveAll((Iterable)vidEntitiesAssined);
        this.vidRepository.deleteAll((Iterable)vidEntities);
    }
}

