/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.verticle;

import io.mosip.kernel.uingenerator.service.UinService;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class UinTransferVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(UinTransferVerticle.class);
    private UinService uinService;
    private Environment environment;

    public UinTransferVerticle(ApplicationContext context) {
        this.environment = (Environment)context.getBean(Environment.class);
        this.uinService = (UinService)context.getBean(UinService.class);
    }

    public void start(Future<Void> startFuture) throws Exception {
        this.vertx.deployVerticle("ceylon:herd.schedule.chime/0.2.0", arg_0 -> this.schedulerResult(arg_0));
    }

    public void schedulerResult(AsyncResult<String> result) {
        if (result.succeeded()) {
            LOGGER.debug((Object)"scheduler verticle deployment successfull");
            this.cronScheduling(this.vertx);
        } else if (result.failed()) {
            LOGGER.error((Object)"scheduler verticle deployment failed with cause ", result.cause());
        }
    }

    private void cronScheduling(Vertx vertx) {
        EventBus eventBus = vertx.eventBus();
        MessageConsumer consumer = eventBus.consumer("scheduler:uin_transfer");
        consumer.handler(message -> this.uinService.transferUin());
        JsonObject timer = new JsonObject().put("type", this.environment.getProperty("kernel.uin.transfer-scheduler-type")).put("seconds", this.environment.getProperty("kernel.uin.transfer-scheduler-seconds")).put("minutes", this.environment.getProperty("kernel.uin.transfer-scheduler-minutes")).put("hours", this.environment.getProperty("kernel.uin.transfer-scheduler-hours")).put("days of month", this.environment.getProperty("kernel.uin.transfer-scheduler-days_of_month")).put("months", this.environment.getProperty("kernel.uin.transfer-scheduler-months")).put("days of week", this.environment.getProperty("kernel.uin.transfer-scheduler-days_of_week"));
        eventBus.send("chime", (Object)new JsonObject().put("operation", "create").put("name", "scheduler:uin_transfer").put("description", timer), res -> {
            if (res.succeeded()) {
                LOGGER.debug((Object)"VIDRevokerschedular started");
            } else if (res.failed()) {
                LOGGER.error((Object)"VIDRevokerschedular failed with cause ", res.cause());
                vertx.close();
            }
        });
    }
}

