/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.verticle;

import io.mosip.kernel.uingenerator.generator.UinProcesser;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationContext;

public class UinGeneratorVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(UinGeneratorVerticle.class);
    private UinProcesser uinProcesser;
    private AtomicBoolean locked = new AtomicBoolean(false);

    public UinGeneratorVerticle(ApplicationContext context) {
        this.uinProcesser = (UinProcesser)context.getBean("uinProcesser");
    }

    public void start() {
        this.vertx.eventBus().consumer("UIN_GENERATOR_ADDRESS", receivedMessage -> {
            if (receivedMessage.body().equals("GENERATE_UIN") && this.uinProcesser.shouldGenerateUins() && !this.locked.get()) {
                this.vertx.executeBlocking(future -> {
                    this.locked.set(true);
                    this.uinProcesser.generateUins();
                    future.complete();
                }, result -> {
                    if (result.succeeded()) {
                        this.locked.set(false);
                        LOGGER.info((Object)"Generated and persisted uins lock set to false");
                    } else {
                        LOGGER.error((Object)"Uin Genaration failed", result.cause());
                    }
                });
            } else {
                LOGGER.info((Object)"Generated and persisted uins lock is true.");
            }
            receivedMessage.reply((Object)"active");
        });
    }
}

