/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.generator;

import io.mosip.kernel.core.idgenerator.spi.UinGenerator;
import io.mosip.kernel.core.util.ChecksumUtils;
import io.mosip.kernel.uingenerator.entity.BaseEntity;
import io.mosip.kernel.uingenerator.entity.UinEntity;
import io.mosip.kernel.uingenerator.generator.UinWriter;
import io.mosip.kernel.uingenerator.service.UinService;
import io.mosip.kernel.uingenerator.util.UINMetaDataUtil;
import io.mosip.kernel.uingenerator.util.UinFilterUtil;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UinGeneratorImpl
implements UinGenerator {
    @Autowired
    private UinFilterUtil uinFilterUtils;
    @Autowired
    private UINMetaDataUtil metaDataUtil;
    @Autowired
    private UinService uinService;
    @Autowired
    private UinWriter uinWriter;
    private static final Logger LOGGER = LoggerFactory.getLogger(UinGeneratorImpl.class);
    private final long uinsCount;
    private final int uinLength;
    private final String uinDefaultStatus;
    private SecureRandom random;
    private static final RandomDataGenerator RANDOM_DATA_GENERATOR = new RandomDataGenerator();

    @PostConstruct
    private void init() {
        this.random = new SecureRandom();
    }

    public UinGeneratorImpl(@Value(value="${mosip.kernel.uin.uins-to-generate}") long uinsCount, @Value(value="${mosip.kernel.uin.length}") int uinLength) {
        this.uinsCount = uinsCount;
        this.uinLength = uinLength;
        this.uinDefaultStatus = "UNUSED";
    }

    public void generateId(long noOfUINToGenerate) {
        int generatedIdLength = this.uinLength - 1;
        long uinCount = 0L;
        long upperBound = Long.parseLong(StringUtils.repeat((String)"9", (int)generatedIdLength));
        long lowerBound = Long.parseLong(StringUtils.repeat((String)"0", (int)generatedIdLength));
        this.uinWriter.setSession();
        while (uinCount < noOfUINToGenerate) {
            String generatedUIN = this.generateSingleId(generatedIdLength, lowerBound, upperBound);
            if (!this.uinFilterUtils.isValidId(generatedUIN) || this.uinService.uinExist(generatedUIN)) continue;
            UinEntity uinBean = new UinEntity(generatedUIN, this.uinDefaultStatus);
            this.metaDataUtil.setCreateMetaData((BaseEntity)uinBean);
            this.uinWriter.persistUin(uinBean);
            ++uinCount;
        }
        this.uinWriter.closeSession();
        LOGGER.info((Object)"Generated {} uins ", new Object[]{this.uinsCount});
    }

    private String generateSingleId(int generatedIdLength, long lowerBound, long upperBound) {
        byte[] randomSeedBytes = new byte[generatedIdLength];
        this.random.nextBytes(randomSeedBytes);
        String generatedID = new BigInteger(randomSeedBytes).abs().toString().substring(0, generatedIdLength);
        String verhoeffDigit = ChecksumUtils.generateChecksumDigit((String)String.valueOf(generatedID));
        return this.appendChecksum(generatedIdLength, generatedID, verhoeffDigit);
    }

    private String appendChecksum(int generatedIdLength, String generatedID, String verhoeffDigit) {
        StringBuilder uinStringBuilder = new StringBuilder();
        uinStringBuilder.setLength(this.uinLength);
        return uinStringBuilder.insert(0, generatedID).insert(generatedID.length(), verhoeffDigit).toString().trim();
    }
}

