/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:bootstrap.properties"}), @PropertySource(value={"classpath:application-${spring.profiles.active}.properties"}, ignoreResourceNotFound=true)})
@EnableJpaRepositories(basePackages={"io.mosip.kernel.vidgenerator.repository", "io.mosip.kernel.uingenerator.repository"})
@ComponentScan(basePackages={"io.mosip.kernel.vidgenerator.*", "io.mosip.kernel.uingenerator.*", "io.mosip.kernel.idgenerator.vid.*", "io.mosip.kernel.crypto.*", "${mosip.auth.adapter.impl.basepackage}", "io.mosip.kernel.cryptosignature.*", "io.mosip.kernel.idgenerator.*", "io.mosip.kernel.keygenerator.bouncycastle"})
@EnableTransactionManagement
public class HibernateDaoConfig
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateDaoConfig.class);
    @Autowired
    private Environment env;
    @Value(value="${mosip.kernel.vid.hikari_maximumPoolSize:10}")
    private int maximumPoolSize;
    @Value(value="${hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${hikari.minimumIdle:0}")
    private int minimumIdle;

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Bean
    @Autowired
    public DataSource dataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.env.getProperty("javax.persistence.jdbc.driver"));
        hikariConfig.setJdbcUrl(this.env.getProperty("id_database_url"));
        hikariConfig.setUsername(this.env.getProperty("id_database_username"));
        hikariConfig.setPassword(this.env.getProperty("id_database_password"));
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    @Autowired
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean entityManagerFactory = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactory.setDataSource(dataSource);
        entityManagerFactory.setPackagesToScan(new String[]{"io.mosip.kernel.vidgenerator.entity", "io.mosip.kernel.uingenerator.entity"});
        entityManagerFactory.setJpaPropertyMap(this.jpaProperties());
        entityManagerFactory.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        return entityManagerFactory;
    }

    @Bean(name={"transactionManager"})
    @Autowired
    public PlatformTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager jpaTransactionManager = new JpaTransactionManager(entityManagerFactory);
        jpaTransactionManager.setDataSource(this.dataSource());
        return jpaTransactionManager;
    }

    public Map<String, Object> jpaProperties() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        this.getProperty(jpaProperties, "hibernate.hbm2ddl.auto", "update");
        this.getProperty(jpaProperties, "hibernate.dialect", null);
        this.getProperty(jpaProperties, "hibernate.show_sql", "true");
        this.getProperty(jpaProperties, "hibernate.format_sql", "true");
        this.getProperty(jpaProperties, "hibernate.connection.charSet", "utf8");
        this.getProperty(jpaProperties, "hibernate.cache.use_second_level_cache", "false");
        this.getProperty(jpaProperties, "hibernate.cache.use_query_cache", "false");
        this.getProperty(jpaProperties, "hibernate.cache.use_structured_entries", "false");
        this.getProperty(jpaProperties, "hibernate.generate_statistics", "false");
        this.getProperty(jpaProperties, "hibernate.jdbc.lob.non_contextual_creation", "false");
        this.getProperty(jpaProperties, "hibernate.current_session_context_class", "jta");
        this.getProperty(jpaProperties, "hibernate.ejb.interceptor", "hibernate.empty.interceptor");
        return jpaProperties;
    }

    private HashMap<String, Object> getProperty(HashMap<String, Object> jpaProperties, String property, String defaultValue) {
        if (property.equals("hibernate.ejb.interceptor")) {
            try {
                if (this.env.containsProperty(property)) {
                    jpaProperties.put(property, BeanUtils.instantiateClass(Class.forName(this.env.getProperty(property))));
                }
            }
            catch (ClassNotFoundException | BeanInstantiationException e) {
                LOGGER.error(e.getMessage());
            }
        } else {
            jpaProperties.put(property, this.env.containsProperty(property) ? this.env.getProperty(property) : defaultValue);
        }
        return jpaProperties;
    }
}

