/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptosignature.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilClientException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilException;
import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.signatureutil.spi.SignatureUtil;
import io.mosip.kernel.cryptosignature.constant.SigningDataErrorCode;
import io.mosip.kernel.cryptosignature.dto.SignResponseDto;
import io.mosip.kernel.cryptosignature.dto.SignatureRequestDto;
import io.mosip.kernel.cryptosignature.exception.ExceptionHandler;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Component
public class SignatureUtilImpl
implements SignatureUtil {
    @Value(value="${mosip.kernel.signature.signature-request-id}")
    private String signDataRequestId;
    @Value(value="${mosip.kernel.signature.signature-version-id}")
    private String signDataVersionId;
    @Value(value="${mosip.kernel.keymanager-service-sign-url}")
    private String signUrl;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    private static final String RESPONSE_SOURCE = "Keymanager";

    public boolean validateWithPublicKey(String signature, String data, String publickey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        throw new SignatureUtilException(SigningDataErrorCode.REST_NOT_SUPPORTED_EXCEPTION.getErrorCode(), SigningDataErrorCode.REST_NOT_SUPPORTED_EXCEPTION.getErrorMessage());
    }

    public SignatureResponse sign(String response) {
        SignatureRequestDto signatureRequestDto = new SignatureRequestDto();
        signatureRequestDto.setData(response);
        RequestWrapper requestWrapper = new RequestWrapper();
        requestWrapper.setId(this.signDataRequestId);
        requestWrapper.setVersion(this.signDataVersionId);
        requestWrapper.setRequest((Object)signatureRequestDto);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.postForEntity(this.signUrl, (Object)requestWrapper, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            ExceptionHandler.authExceptionHandler((HttpStatusCodeException)ex, (List)validationErrorsList, (String)RESPONSE_SOURCE);
            if (!validationErrorsList.isEmpty()) {
                throw new SignatureUtilClientException(validationErrorsList);
            }
            throw new SignatureUtilException(SigningDataErrorCode.REST_CRYPTO_CLIENT_EXCEPTION.getErrorCode(), SigningDataErrorCode.REST_CRYPTO_CLIENT_EXCEPTION.getErrorMessage(), ex);
        }
        ExceptionHandler.throwExceptionIfExist((ResponseEntity)responseEntity);
        SignResponseDto signatureResponse = (SignResponseDto)ExceptionHandler.getResponse((ObjectMapper)this.objectMapper, (ResponseEntity)responseEntity, SignResponseDto.class);
        SignatureResponse signatureResp = new SignatureResponse();
        signatureResp.setData(signatureResponse.getSignature());
        signatureResp.setTimestamp(signatureResponse.getTimestamp());
        return signatureResp;
    }

    public boolean validate(String signature, String actualData, String timestamp) {
        throw new SignatureUtilException(SigningDataErrorCode.REST_NOT_SUPPORTED_EXCEPTION.getErrorCode(), SigningDataErrorCode.REST_NOT_SUPPORTED_EXCEPTION.getErrorMessage());
    }
}

