/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.verticle;

import io.mosip.kernel.vidgenerator.service.VidService;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class VidIsolatorVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(VidIsolatorVerticle.class);
    private VidService vidService;
    private Environment environment;

    public VidIsolatorVerticle(ApplicationContext context) {
        this.environment = (Environment)context.getBean(Environment.class);
        this.vidService = (VidService)context.getBean(VidService.class);
    }

    public void start(Future<Void> startFuture) throws Exception {
        this.vertx.deployVerticle("ceylon:herd.schedule.chime/0.2.0", arg_0 -> this.schedulerResult(arg_0));
    }

    public void schedulerResult(AsyncResult<String> result) {
        if (result.succeeded()) {
            LOGGER.info((Object)"VidIsolatorVerticle deployment successfull");
            this.cronScheduling(this.vertx);
        } else if (result.failed()) {
            LOGGER.error((Object)"VidIsolatorVerticle deployment failed with cause ", result.cause());
        }
    }

    private void cronScheduling(Vertx vertx) {
        EventBus eventBus = vertx.eventBus();
        MessageConsumer consumer = eventBus.consumer("scheduler:vid_isolator");
        consumer.handler(message -> this.vidService.isolateAssignedVids());
        JsonObject timer = new JsonObject().put("type", this.environment.getProperty("kernel.vid.isolator-scheduler-type")).put("seconds", this.environment.getProperty("kernel.vid.isolator-scheduler-seconds")).put("minutes", this.environment.getProperty("kernel.vid.isolator-scheduler-minutes")).put("hours", this.environment.getProperty("kernel.vid.isolator-scheduler-hours")).put("days of month", this.environment.getProperty("kernel.vid.isolator-scheduler-days_of_month")).put("months", this.environment.getProperty("kernel.vid.isolator-scheduler-months")).put("days of week", this.environment.getProperty("kernel.vid.isolator-scheduler-days_of_week"));
        eventBus.send("chime", (Object)new JsonObject().put("operation", "create").put("name", "scheduler:vid_isolator").put("description", timer), res -> {
            if (res.succeeded()) {
                LOGGER.info((Object)"VidIsolatorVerticle started");
            } else if (res.failed()) {
                LOGGER.error((Object)"VidIsolatorVerticle failed with cause ", res.cause());
                vertx.close();
            }
        });
    }
}

