/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.generator;

import io.mosip.kernel.uingenerator.entity.UinEntity;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UinWriter {
    @Autowired
    private EntityManager entityManager;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistUin(UinEntity item) {
        Session currentSession = this.getSession();
        if (!currentSession.getTransaction().isActive()) {
            currentSession.getTransaction().begin();
        }
        currentSession.save((Object)item);
        try {
            currentSession.flush();
            currentSession.getTransaction().commit();
        }
        catch (PersistenceException e) {
            currentSession.getTransaction().rollback();
        }
        finally {
            currentSession.clear();
        }
    }

    public void setSession() {
        this.entityManager = this.entityManager.getEntityManagerFactory().createEntityManager();
        this.session = (Session)this.entityManager.unwrap(Session.class);
    }

    private Session getSession() {
        if (this.session == null) {
            this.setSession();
        }
        return this.session;
    }

    public void closeSession() {
        if (this.session != null) {
            this.session.clear();
        }
    }
}

