/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.generator;

import io.mosip.kernel.core.idgenerator.spi.UinGenerator;
import io.mosip.kernel.uingenerator.repository.UinRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UinProcesser {
    @Autowired
    private UinRepository uinRepository;
    @Autowired
    private UinGenerator uinGeneratorImpl;
    @Value(value="${mosip.kernel.uin.min-unused-threshold}")
    private long thresholdUinCount;
    @Value(value="${mosip.kernel.uin.uins-to-generate}")
    long uinsCount;

    public boolean shouldGenerateUins() {
        long freeUinsCount = this.uinRepository.countByStatus("UNUSED");
        return freeUinsCount < this.thresholdUinCount;
    }

    public void generateUins() {
        long noOfUnUsedUins = this.uinRepository.countByStatusAndIsDeletedFalse("UNUSED");
        this.uinGeneratorImpl.generateId(this.uinsCount <= noOfUnUsedUins ? 0L : this.uinsCount - noOfUnUsedUins);
    }
}

