/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.auth.defaultadapter.handler.AuthHandler;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilClientException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilException;
import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.signatureutil.spi.SignatureUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.idgenerator.config.UinServiceHealthCheckerhandler;
import io.mosip.kernel.uingenerator.constant.UinGeneratorErrorCode;
import io.mosip.kernel.uingenerator.dto.UinResponseDto;
import io.mosip.kernel.uingenerator.dto.UinStatusUpdateReponseDto;
import io.mosip.kernel.uingenerator.entity.UinEntity;
import io.mosip.kernel.uingenerator.exception.UinNotFoundException;
import io.mosip.kernel.uingenerator.exception.UinNotIssuedException;
import io.mosip.kernel.uingenerator.exception.UinStatusNotFoundException;
import io.mosip.kernel.uingenerator.service.UinService;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class UinServiceRouter {
    @Autowired
    Environment environment;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private AuthHandler authHandler;
    @Autowired
    private SignatureUtil signatureUtil;
    @Autowired
    private UinService uinGeneratorService;
    private Logger LOGGER = LoggerFactory.getLogger(UinServiceRouter.class);

    public Router createRouter(Vertx vertx) {
        Router router = Router.router((Vertx)vertx);
        int workerExecutorPool = (Integer)this.environment.getProperty("mosip.kernel.uin.get_executor_pool", Integer.class, (Object)400);
        this.LOGGER.info((Object)"worker executor pool {}", new Object[]{workerExecutorPool});
        String servletPath = this.environment.getProperty("server.servlet.path");
        String profile = this.environment.getProperty("spring.profiles.active");
        boolean isSignEnable = (Boolean)this.environment.getProperty("mosip.kernel.uin.response-signing-enable", Boolean.TYPE, (Object)false);
        router.route().handler(routingContext -> {
            routingContext.response().headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            routingContext.next();
        });
        this.authHandler.addAuthFilter(router, "/", HttpMethod.GET, "REGISTRATION_PROCESSOR");
        router.get().handler(routingContext -> this.getRouter(vertx, routingContext, isSignEnable, profile, router, workerExecutorPool));
        this.authHandler.addAuthFilter(router, "/", HttpMethod.PUT, "REGISTRATION_PROCESSOR");
        router.route().handler((Handler)BodyHandler.create());
        router.put().consumes("application/json").handler(arg_0 -> this.updateRouter(arg_0));
        this.configureHealthCheckEndpoint(vertx, router, servletPath);
        router.route(this.environment.getProperty("server.servlet.path") + "/*").handler((Handler)StaticHandler.create().setCachingEnabled(false).setWebRoot("swagger-ui").setAlwaysAsyncFS(true).setAllowRootFileSystemAccess(true));
        return router;
    }

    private void configureHealthCheckEndpoint(Vertx vertx, Router router, String servletPath) {
        UinServiceHealthCheckerhandler healthCheckHandler = new UinServiceHealthCheckerhandler(vertx, null, this.objectMapper, this.environment);
        router.get(servletPath + "/actuator/health").handler((Handler)healthCheckHandler);
        healthCheckHandler.register("db", arg_0 -> ((UinServiceHealthCheckerhandler)healthCheckHandler).databaseHealthChecker(arg_0));
        healthCheckHandler.register("diskspace", arg_0 -> ((UinServiceHealthCheckerhandler)healthCheckHandler).dispSpaceHealthChecker(arg_0));
        healthCheckHandler.register("uingeneratorverticle", future -> healthCheckHandler.verticleHealthHandler(future, vertx));
    }

    private void getRouter(Vertx vertx, RoutingContext routingContext, boolean isSignEnable, String profile, Router router, int workerExecutorPool) {
        ResponseWrapper reswrp = new ResponseWrapper();
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        WorkerExecutor executor = vertx.createSharedWorkerExecutor("get-uin", workerExecutorPool);
        executor.executeBlocking(blockingCodeHandler -> {
            try {
                this.checkAndGenerateUins(vertx);
                UinResponseDto uin = new UinResponseDto();
                uin = this.uinGeneratorService.getUin();
                reswrp.setResponsetime(DateUtils.convertUTCToLocalDateTime((String)timestamp));
                reswrp.setResponse((Object)uin);
                reswrp.setErrors(null);
                blockingCodeHandler.complete();
            }
            catch (UinNotFoundException e) {
                ServiceError error = new ServiceError(UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorMessage());
                this.setError(routingContext, error, blockingCodeHandler);
            }
        }, false, resultHandler -> {
            if (resultHandler.succeeded()) {
                if (isSignEnable) {
                    String signedData = null;
                    String resWrpJsonString = null;
                    SignatureResponse cryptoManagerResponseDto = null;
                    try {
                        resWrpJsonString = this.objectMapper.writeValueAsString((Object)reswrp);
                        cryptoManagerResponseDto = this.signatureUtil.sign(resWrpJsonString);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                    }
                    catch (SignatureUtilClientException e1) {
                        ExceptionUtils.logRootCause((Throwable)e1);
                        this.setError(routingContext, (ServiceError)e1.getList().get(0));
                    }
                    catch (SignatureUtilException e1) {
                        ExceptionUtils.logRootCause((Throwable)e1);
                        ServiceError error = new ServiceError(UinGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), e1.toString());
                        this.setError(routingContext, error);
                    }
                    signedData = cryptoManagerResponseDto.getData();
                    routingContext.response().putHeader("response-signature", signedData);
                }
                try {
                    routingContext.response().putHeader("content-type", "application/json").setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)reswrp));
                }
                catch (JsonProcessingException jsonProcessingException) {}
            } else {
                try {
                    routingContext.response().putHeader("content-type", "application/json").setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)resultHandler.cause().getMessage()));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
        });
    }

    private void updateRouter(RoutingContext routingContext) {
        UinEntity uin;
        RequestWrapper reqwrp;
        UinStatusUpdateReponseDto uinresponse = null;
        try {
            reqwrp = (RequestWrapper)this.objectMapper.readValue(routingContext.getBodyAsJson().toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            uin = (UinEntity)reqwrp.getRequest();
        }
        catch (Exception e) {
            ServiceError error = new ServiceError(UinGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), e.getMessage());
            this.setError(routingContext, error);
            return;
        }
        if (uin == null) {
            routingContext.response().setStatusCode(200).end();
            return;
        }
        try {
            uinresponse = this.uinGeneratorService.updateUinStatus(uin);
            ResponseWrapper reswrp = new ResponseWrapper();
            reswrp.setResponse((Object)uinresponse);
            reswrp.setId(reqwrp.getId());
            reswrp.setVersion(reqwrp.getVersion());
            reswrp.setErrors(null);
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)reswrp));
        }
        catch (UinNotFoundException e) {
            ExceptionUtils.logRootCause((Throwable)e);
            ServiceError error = new ServiceError(UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorMessage());
            this.setError(routingContext, error, reqwrp);
        }
        catch (UinStatusNotFoundException e) {
            ServiceError error = new ServiceError(UinGeneratorErrorCode.UIN_STATUS_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_STATUS_NOT_FOUND.getErrorMessage());
            this.setError(routingContext, error, reqwrp);
        }
        catch (UinNotIssuedException e) {
            ServiceError error = new ServiceError(UinGeneratorErrorCode.UIN_NOT_ISSUED.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_ISSUED.getErrorMessage());
            this.setError(routingContext, error, reqwrp);
        }
        catch (Exception e) {
            ExceptionUtils.logRootCause((Throwable)e);
            ServiceError error = new ServiceError(UinGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), e.getMessage());
            this.setError(routingContext, error, reqwrp);
        }
    }

    public void checkAndGenerateUins(Vertx vertx) {
        vertx.eventBus().publish("UIN_GENERATOR_ADDRESS", (Object)"GENERATE_UIN");
    }

    private void setError(RoutingContext routingContext, ServiceError error) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().add(error);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (routingContext.getBodyAsJson() != null) {
            try {
                JsonNode reqNode = this.objectMapper.readTree(routingContext.getBodyAsJson().toString());
                errorResponse.setId(reqNode.path("id").asText());
                errorResponse.setVersion(reqNode.path("version").asText());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)errorResponse));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    private void setError(RoutingContext routingContext, ServiceError error, RequestWrapper<UinEntity> reqwrp) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().add(error);
        errorResponse.setId(reqwrp.getId());
        errorResponse.setVersion(reqwrp.getVersion());
        try {
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)errorResponse));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    private void setError(RoutingContext routingContext, ServiceError error, Future<Object> blockingHandler) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().add(error);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (routingContext.getBodyAsJson() != null) {
            try {
                JsonNode reqNode = this.objectMapper.readTree(routingContext.getBodyAsJson().toString());
                errorResponse.setId(reqNode.path("id").asText());
                errorResponse.setVersion(reqNode.path("version").asText());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            blockingHandler.fail(this.objectMapper.writeValueAsString((Object)errorResponse));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

