/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.idgenerator.config.BaseHealthCheckModel;
import io.mosip.kernel.idgenerator.config.UinServiceHealthCheckerhandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.HealthChecksImpl;
import io.vertx.ext.healthchecks.impl.StatusHelper;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.support.JdbcUtils;

public class UinServiceHealthCheckerhandler
implements HealthCheckHandler {
    private HealthChecks healthChecks;
    private final AuthProvider authProvider;
    private ObjectMapper objectMapper;
    private String driver;
    private String url;
    private String username;
    private String password;
    private File currentWorkingDirPath;
    private static final int THRESHOLD = 0xA00000;
    private static final String DEFAULT_QUERY = "SELECT 1";
    private JSONResultBuilder resultBuilder;
    private static final Logger LOGGER = LoggerFactory.getLogger(UinServiceHealthCheckerhandler.class);

    public UinServiceHealthCheckerhandler(Vertx vertx, AuthProvider provider, ObjectMapper objectMapper, Environment environment) {
        this.healthChecks = new HealthChecksImpl(vertx);
        this.authProvider = provider;
        this.objectMapper = objectMapper;
        this.driver = environment.getProperty("javax.persistence.jdbc.driver");
        this.url = environment.getProperty("uin_database_url");
        this.username = environment.getProperty("uin_database_username");
        this.password = environment.getProperty("uin_database_password");
        this.currentWorkingDirPath = new File(System.getProperty("user.dir"));
        this.resultBuilder = new JSONResultBuilder();
    }

    public HealthCheckHandler register(String name, Handler<Future<Status>> procedure) {
        this.healthChecks.register(name, procedure);
        return this;
    }

    public HealthCheckHandler register(String name, long timeout, Handler<Future<Status>> procedure) {
        this.healthChecks.register(name, timeout, procedure);
        return this;
    }

    public void databaseHealthChecker(Future<Status> future) {
        JsonObject result;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException exception) {
            result = this.resultBuilder.create().add("error", (Object)exception.getMessage()).build();
            future.complete((Object)Status.KO((JsonObject)result));
        }
        try (Connection conn = DriverManager.getConnection(this.url, this.username, this.password);
             Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(DEFAULT_QUERY);){
            if (rs.next()) {
                JsonObject result2 = this.resultBuilder.create().add("database", (Object)conn.getMetaData().getDatabaseProductName()).add("hello", JdbcUtils.getResultSetValue((ResultSet)rs, (int)1)).build();
                future.complete((Object)Status.OK((JsonObject)result2));
            }
        }
        catch (SQLException exception) {
            result = this.resultBuilder.create().add("error", (Object)exception.getMessage()).build();
            future.complete((Object)Status.KO((JsonObject)result));
        }
    }

    public void dispSpaceHealthChecker(Future<Status> future) {
        long diskFreeInBytes = this.currentWorkingDirPath.getUsableSpace();
        if (diskFreeInBytes >= 0xA00000L) {
            JsonObject result = this.resultBuilder.create().add("total", (Object)this.currentWorkingDirPath.getTotalSpace()).add("free", (Object)diskFreeInBytes).add("threshold", (Object)0xA00000).build();
            future.complete((Object)Status.OK((JsonObject)result));
        } else {
            JsonObject result = this.resultBuilder.create().add("error", (Object)String.format("Free disk space below threshold. Available: %d bytes (threshold: %d bytes)", diskFreeInBytes, 0xA00000)).build();
            future.complete((Object)Status.KO((JsonObject)result));
        }
    }

    public void verticleHealthHandler(Future<Status> future, Vertx vertx) {
        vertx.eventBus().send("UIN_GENERATOR_ADDRESS", (Object)"ping", response -> {
            if (response.succeeded()) {
                JsonObject result = this.resultBuilder.create().add("response", ((Message)response.result()).body()).build();
                future.complete((Object)Status.OK((JsonObject)result));
            } else {
                future.complete((Object)Status.KO());
            }
        });
    }

    public void handle(RoutingContext rc) {
        String path = rc.request().path();
        String mount = rc.mountPoint();
        String route = rc.currentRoute().getPath();
        if (mount != null && path.startsWith(mount)) {
            path = path.substring(mount.length());
        }
        String id = route != null && path.startsWith(route) ? path.substring(route.length()) : path;
        if (this.authProvider != null) {
            JsonObject authData = new JsonObject();
            rc.request().headers().forEach(entry -> authData.put((String)entry.getKey(), (String)entry.getValue()));
            rc.request().params().forEach(entry -> authData.put((String)entry.getKey(), (String)entry.getValue()));
            if (rc.request().method() == HttpMethod.POST && rc.request().getHeader(HttpHeaders.CONTENT_TYPE) != null && rc.request().getHeader(HttpHeaders.CONTENT_TYPE).contains("application/json")) {
                authData.mergeIn(rc.getBodyAsJson());
            }
            this.authProvider.authenticate(authData, ar -> {
                if (ar.failed()) {
                    rc.response().setStatusCode(403).end();
                } else {
                    this.healthChecks.invoke(id, this.healthSummaryHandler(rc));
                }
            });
        } else {
            this.healthChecks.invoke(id, this.healthSummaryHandler(rc));
        }
    }

    private Handler<AsyncResult<JsonObject>> healthSummaryHandler(RoutingContext rc) {
        return json -> {
            HttpServerResponse response = rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json;charset=UTF-8");
            if (json.failed()) {
                if (json.cause().getMessage().toLowerCase().contains("not found")) {
                    response.setStatusCode(404);
                } else {
                    response.setStatusCode(400);
                }
                response.end("{\"message\": \"" + json.cause().getMessage() + "\"}");
            } else {
                this.createResponse((JsonObject)json.result(), response);
            }
        };
    }

    private void createResponse(JsonObject json, HttpServerResponse response) {
        int status;
        int n = status = StatusHelper.isUp((JsonObject)json) ? 200 : 503;
        if (status == 503 && this.hasErrors(json)) {
            status = 500;
        }
        json.put("details", new JsonObject());
        JsonArray checks = json.getJsonArray("checks");
        if (status == 200 && checks.isEmpty()) {
            response.setStatusCode(204).end();
            return;
        }
        if (checks != null && !checks.isEmpty()) {
            this.createResponse(json, checks);
        }
        response.setStatusCode(status).end(this.encode(json));
    }

    private void createResponse(JsonObject json, JsonArray checks) {
        for (int i = 0; i < checks.size(); ++i) {
            JsonObject jsonobject = checks.getJsonObject(i);
            String id = jsonobject.getString("id");
            BaseHealthCheckModel healthCheckModel = new BaseHealthCheckModel();
            healthCheckModel.setStatus(jsonobject.getString("status"));
            JsonObject result = null;
            try {
                if (jsonobject.containsKey("data")) {
                    healthCheckModel.setDetails(jsonobject.getJsonObject("data").getMap());
                    result = new JsonObject(this.objectMapper.writeValueAsString((Object)healthCheckModel));
                } else {
                    result = new JsonObject(this.objectMapper.writeValueAsString((Object)healthCheckModel));
                    result.remove("details");
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage());
            }
            json.getJsonObject("details").put(id, result);
        }
    }

    public synchronized HealthCheckHandler unregister(String name) {
        this.healthChecks.unregister(name);
        return this;
    }

    private boolean hasErrors(JsonObject json) {
        JsonObject data = json.getJsonObject("data");
        if (data != null && data.getBoolean("procedure-execution-failure", Boolean.valueOf(false)).booleanValue()) {
            return true;
        }
        JsonArray checks = json.getJsonArray("checks");
        if (checks != null) {
            for (int i = 0; i < checks.size(); ++i) {
                JsonObject check = checks.getJsonObject(i);
                if (!this.hasErrors(check)) continue;
                return true;
            }
        }
        return false;
    }

    private String encode(JsonObject json) {
        String outcome = json.getString("outcome");
        json.remove("outcome");
        json.put("status", outcome);
        return json.encode();
    }
}

