/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.verticle;

import io.mosip.kernel.core.idgenerator.spi.VidGenerator;
import io.mosip.kernel.vidgenerator.entity.BaseEntity;
import io.mosip.kernel.vidgenerator.entity.VidEntity;
import io.mosip.kernel.vidgenerator.generator.VidWriter;
import io.mosip.kernel.vidgenerator.utils.VIDMetaDataUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class VidPopulatorVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(VidPopulatorVerticle.class);
    private long vidToGenerate;
    private Environment environment;
    private VidWriter vidWriter;
    private VIDMetaDataUtil metaDataUtil;
    private VidGenerator<String> vidGenerator;

    public VidPopulatorVerticle(ApplicationContext context) {
        this.environment = (Environment)context.getBean(Environment.class);
        this.vidToGenerate = (Long)this.environment.getProperty("mosip.kernel.vid.vids-to-generate", Long.class);
        this.vidWriter = (VidWriter)context.getBean("vidWriter", VidWriter.class);
        this.metaDataUtil = (VIDMetaDataUtil)context.getBean(VIDMetaDataUtil.class);
        this.vidGenerator = (VidGenerator)context.getBean(VidGenerator.class);
    }

    public void start(Future<Void> startFuture) throws Exception {
        this.vertx.eventBus().consumer("GENERATE_POOL", handler -> {
            long noOfFreeVids = Long.parseLong(handler.body().toString());
            long noOfVidsToGenerate = this.vidToGenerate - noOfFreeVids;
            LOGGER.info((Object)"Persisting {} vids in pool", new Object[]{noOfVidsToGenerate});
            long count = 0L;
            while (count < this.vidToGenerate) {
                String vid = (String)this.vidGenerator.generateId();
                VidEntity entity = new VidEntity();
                entity.setVid(vid);
                entity.setStatus("AVAILABLE");
                this.metaDataUtil.setCreateMetaData((BaseEntity)entity);
                boolean isPersisted = this.vidWriter.persistVids(entity);
                if (!isPersisted) continue;
                ++count;
            }
            handler.reply((Object)"pool population successfull");
            LOGGER.info((Object)"No of vids persisted are {}", new Object[]{count});
        });
    }
}

