/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class UinFilterUtil {
    @Value(value="${mosip.kernel.uin.length}")
    private int uinLength;
    @Value(value="${mosip.kernel.uin.length.sequence-limit}")
    private int sequenceLimit;
    @Value(value="${mosip.kernel.uin.length.repeating-block-limit}")
    private int repeatingBlockLimit;
    @Value(value="${mosip.kernel.uin.length.repeating-limit}")
    private int repeatingLimit;
    @Value(value="${mosip.kernel.uin.length.reverse-digits-limit}")
    private int reverseDigitsGroupLimit;
    @Value(value="${mosip.kernel.uin.length.digits-limit}")
    private int digitsGroupLimit;
    @Value(value="${mosip.kernel.uin.length.conjugative-even-digits-limit}")
    private int conjugativeEvenDigitsLimit;
    @Value(value="#{'${mosip.kernel.uin.restricted-numbers}'.split(',')}")
    private List<String> restrictedAdminDigits;
    @Value(value="#{'${mosip.kernel.uin.not-start-with}'.split(',')}")
    private List<String> notStartWith;
    private static final String SEQ_ASC = "01234567890123456789";
    private static final String SEQ_DEC = "98765432109876543210";
    private static final String[] CYCLIC_NUM = new String[]{"142857", "0588235294117647", "052631578947368421", "0434782608695652173913", "0344827586206896551724137931", "0212765957446808510638297872340425531914893617", "0169491525423728813559322033898305084745762711864406779661", "016393442622950819672131147540983606557377049180327868852459", "010309278350515463917525773195876288659793814432989690721649484536082474226804123711340206185567"};
    private Pattern repeatingPattern = null;
    private Pattern repeatingBlockPattern = null;
    private Pattern conjugativeEvenDigitsLimitPattern = null;

    @PostConstruct
    public void initializeRegEx() {
        String repeatingRegEx = "(\\d)\\d{0," + (this.repeatingLimit - 1) + "}\\1";
        String repeatingBlockRegEx = "(\\d{" + this.repeatingBlockLimit + ",}).*?\\1";
        String conjugativeEvenDigitsLimitRegEx = "[2468]{" + this.conjugativeEvenDigitsLimit + "}";
        this.repeatingPattern = Pattern.compile(repeatingRegEx);
        this.repeatingBlockPattern = Pattern.compile(repeatingBlockRegEx);
        this.conjugativeEvenDigitsLimitPattern = Pattern.compile(conjugativeEvenDigitsLimitRegEx);
    }

    public boolean isValidId(String id) {
        return !this.sequenceFilter(id) && !UinFilterUtil.regexFilter((String)id, (Pattern)this.repeatingPattern) && !UinFilterUtil.regexFilter((String)id, (Pattern)this.repeatingBlockPattern) && !UinFilterUtil.regexFilter((String)id, (Pattern)this.conjugativeEvenDigitsLimitPattern) && !this.firstAndLastDigitsValidation(id, this.digitsGroupLimit) && !this.firstAndLastDigitsReverseValidation(id, this.reverseDigitsGroupLimit) && !this.restrictedAdminFilter(id) && !this.validateNotStartWith(id) && !this.validateLength(id) && !this.restrictedCyclicNumFilter(id);
    }

    private boolean restrictedAdminFilter(String id) {
        return this.restrictedAdminDigits.parallelStream().anyMatch(id::contains);
    }

    private boolean sequenceFilter(String id) {
        return IntStream.rangeClosed(0, id.length() - this.sequenceLimit).parallel().mapToObj(index -> id.subSequence(index, index + this.sequenceLimit)).anyMatch(idSubSequence -> "01234567890123456789".contains((CharSequence)idSubSequence) || "98765432109876543210".contains((CharSequence)idSubSequence));
    }

    private static boolean regexFilter(String id, Pattern pattern) {
        return pattern.matcher(id).find();
    }

    private boolean firstAndLastDigitsReverseValidation(String id, int reverseDigitsGroupLimit) {
        StringBuilder lastGroupDigits = new StringBuilder(id.substring(id.length() - reverseDigitsGroupLimit, id.length()));
        String reverseLastGroupDigits = lastGroupDigits.reverse().toString();
        return id.substring(0, reverseDigitsGroupLimit).equals(reverseLastGroupDigits);
    }

    private boolean firstAndLastDigitsValidation(String id, int digitsGroupLimit) {
        return id.substring(0, digitsGroupLimit).equals(id.substring(id.length() - digitsGroupLimit, id.length()));
    }

    private boolean validateNotStartWith(String id) {
        if (this.notStartWith != null && !this.notStartWith.isEmpty()) {
            for (String str : this.notStartWith) {
                if (!id.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateLength(String id) {
        return id.length() != this.uinLength;
    }

    private boolean restrictedCyclicNumFilter(String id) {
        ArrayList<String> cyclicNumList = new ArrayList<String>();
        cyclicNumList.add(CYCLIC_NUM[0]);
        cyclicNumList.add(CYCLIC_NUM[1]);
        cyclicNumList.add(CYCLIC_NUM[2]);
        cyclicNumList.add(CYCLIC_NUM[3]);
        cyclicNumList.add(CYCLIC_NUM[4]);
        cyclicNumList.add(CYCLIC_NUM[5]);
        cyclicNumList.add(CYCLIC_NUM[6]);
        cyclicNumList.add(CYCLIC_NUM[7]);
        cyclicNumList.add(CYCLIC_NUM[8]);
        for (String cyclicNum : cyclicNumList) {
            String cyclicNumRegex;
            Pattern cyclicNumPattern;
            if (id.length() < cyclicNum.length() || !UinFilterUtil.regexFilter((String)id, (Pattern)(cyclicNumPattern = Pattern.compile(cyclicNumRegex = "(" + cyclicNum + ")")))) continue;
            return true;
        }
        return false;
    }
}

