/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.verticle;

import io.mosip.kernel.idgenerator.verticle.HttpServerVerticle;
import io.mosip.kernel.vidgenerator.service.VidService;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class VidPoolCheckerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(VidPoolCheckerVerticle.class);
    private VidService vidService;
    private Environment environment;
    private long threshold;
    private ApplicationContext context;
    private volatile AtomicBoolean locked = new AtomicBoolean(false);

    public VidPoolCheckerVerticle(ApplicationContext context) {
        this.context = context;
        this.vidService = (VidService)this.context.getBean(VidService.class);
        this.environment = (Environment)this.context.getBean(Environment.class);
        this.threshold = (Long)this.environment.getProperty("mosip.kernel.vid.min-unused-threshold", Long.class);
    }

    public void start(Future<Void> startFuture) {
        EventBus eventBus = this.vertx.eventBus();
        MessageConsumer checkPoolConsumer = eventBus.consumer("CHECK_POOL");
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout(((Long)this.environment.getProperty("mosip.kernel.vid.pool-population-timeout", Long.class)).longValue());
        checkPoolConsumer.handler(handler -> {
            long noOfFreeVids = this.vidService.fetchVidCount("AVAILABLE");
            LOGGER.info((Object)"no of vid free present are {}", new Object[]{noOfFreeVids});
            if (noOfFreeVids < this.threshold && !this.locked.get()) {
                this.locked.set(true);
                eventBus.send("GENERATE_POOL", (Object)noOfFreeVids, deliveryOptions, replyHandler -> {
                    if (replyHandler.succeeded()) {
                        this.locked.set(false);
                        LOGGER.info((Object)"population of pool done");
                    } else if (replyHandler.failed()) {
                        this.locked.set(false);
                        LOGGER.error((Object)"population failed with cause ", replyHandler.cause());
                    }
                });
            } else {
                LOGGER.info((Object)"event type is send {} eventBus{}", new Object[]{handler.isSend(), eventBus});
                LOGGER.info((Object)"locked generation");
            }
        });
        MessageConsumer initPoolConsumer = eventBus.consumer("INIT_POOL");
        initPoolConsumer.handler(initPoolHandler -> {
            long start = System.currentTimeMillis();
            long noOfFreeVids = this.vidService.fetchVidCount("AVAILABLE");
            LOGGER.info((Object)"no of vid free present are {}", new Object[]{noOfFreeVids});
            LOGGER.info((Object)"value of threshold is {} and lock is {}", new Object[]{this.threshold, this.locked.get()});
            boolean isEligibleForPool = noOfFreeVids < this.threshold && !this.locked.get();
            LOGGER.info((Object)"is eligible for pool {}", new Object[]{isEligibleForPool});
            if (isEligibleForPool) {
                this.locked.set(true);
                eventBus.send("GENERATE_POOL", (Object)noOfFreeVids, deliveryOptions, replyHandler -> {
                    if (replyHandler.succeeded()) {
                        this.locked.set(false);
                        this.deployHttpVerticle(start);
                        LOGGER.info((Object)"population of init pool done");
                    } else if (replyHandler.failed()) {
                        this.locked.set(false);
                        LOGGER.error((Object)"population failed with cause ", replyHandler.cause());
                        initPoolHandler.fail(100, replyHandler.cause().getMessage());
                    }
                });
            } else {
                this.deployHttpVerticle(start);
            }
        });
    }

    private void deployHttpVerticle(long start) {
        HttpServerVerticle httpVerticle = new HttpServerVerticle(this.context);
        DeploymentOptions opts = new DeploymentOptions();
        this.vertx.deployVerticle((Verticle)httpVerticle, opts, arg_0 -> VidPoolCheckerVerticle.lambda$deployHttpVerticle$4((Verticle)httpVerticle, start, arg_0));
    }

    private static /* synthetic */ void lambda$deployHttpVerticle$4(Verticle httpVerticle, long start, AsyncResult res) {
        if (res.failed()) {
            LOGGER.info((Object)("Failed to deploy verticle " + httpVerticle.getClass().getSimpleName() + " " + res.cause()));
        } else if (res.succeeded()) {
            LOGGER.info((Object)"population of pool is done starting fetcher verticle");
            LOGGER.info((Object)"Starting vidgenerator service... ");
            LOGGER.info((Object)"service took {} ms to pool and start", new Object[]{System.currentTimeMillis() - start});
            LOGGER.info((Object)("Deployed verticle " + httpVerticle.getClass().getSimpleName()));
        }
    }
}

