/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.router;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.vidgenerator.constant.VIDGeneratorErrorCode;
import io.mosip.kernel.vidgenerator.dto.VidFetchResponseDto;
import io.mosip.kernel.vidgenerator.exception.VidGeneratorServiceException;
import io.mosip.kernel.vidgenerator.service.VidService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VidFetcherRouter {
    @Value(value="${mosip.kernel.vid.get_executor_pool:400}")
    private int workerExecutorPool;
    private static final Logger LOGGER = LoggerFactory.getLogger(VidFetcherRouter.class);
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Autowired
    private VidService vidService;
    @Autowired
    private ObjectMapper objectMapper;

    public Router createRouter(Vertx vertx) {
        LOGGER.info((Object)"worker executor pool {}", new Object[]{this.workerExecutorPool});
        Router router = Router.router((Vertx)vertx);
        router.get().handler(routingContext -> {
            LOGGER.info((Object)"publishing event to CHECKPOOL");
            vertx.eventBus().publish("CHECK_POOL", (Object)"CHECK_POOL");
            routingContext.response().headers().add("Content-Type", "application/json");
            ResponseWrapper reswrp = new ResponseWrapper();
            WorkerExecutor executor = vertx.createSharedWorkerExecutor("get-vid", this.workerExecutorPool);
            executor.executeBlocking(blockingCodeHandler -> {
                ServiceError error;
                String expiryDateString = routingContext.request().getParam("videxpiry");
                LocalDateTime expiryTime = null;
                if (expiryDateString != null) {
                    if (expiryDateString.trim().isEmpty()) {
                        ServiceError error2 = new ServiceError(VIDGeneratorErrorCode.VID_EXPIRY_DATE_EMPTY.getErrorCode(), VIDGeneratorErrorCode.VID_EXPIRY_DATE_EMPTY.getErrorMessage());
                        this.setError(routingContext, error2, blockingCodeHandler);
                    }
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN);
                    try {
                        expiryTime = LocalDateTime.parse(expiryDateString, dateTimeFormatter);
                    }
                    catch (DateTimeParseException exception) {
                        error = new ServiceError(VIDGeneratorErrorCode.VID_EXPIRY_DATE_PATTERN_INVALID.getErrorCode(), VIDGeneratorErrorCode.VID_EXPIRY_DATE_PATTERN_INVALID.getErrorMessage());
                        this.setError(routingContext, error, blockingCodeHandler);
                    }
                    if (expiryTime.isBefore(DateUtils.getUTCCurrentDateTime())) {
                        ServiceError error3 = new ServiceError(VIDGeneratorErrorCode.VID_EXPIRY_DATE_INVALID.getErrorCode(), VIDGeneratorErrorCode.VID_EXPIRY_DATE_INVALID.getErrorMessage());
                        this.setError(routingContext, error3, blockingCodeHandler);
                    }
                }
                VidFetchResponseDto vidFetchResponseDto = null;
                try {
                    vidFetchResponseDto = this.vidService.fetchVid(expiryTime);
                }
                catch (VidGeneratorServiceException exception) {
                    error = new ServiceError(exception.getErrorCode(), exception.getMessage());
                    this.setError(routingContext, error, blockingCodeHandler);
                }
                String timestamp = DateUtils.getUTCCurrentDateTimeString();
                reswrp.setResponsetime(DateUtils.convertUTCToLocalDateTime((String)timestamp));
                reswrp.setResponse((Object)vidFetchResponseDto);
                reswrp.setErrors(null);
                blockingCodeHandler.complete();
            }, false, resultHandler -> {
                if (resultHandler.succeeded()) {
                    try {
                        routingContext.response().end(this.objectMapper.writeValueAsString((Object)reswrp));
                    }
                    catch (JsonProcessingException exception) {
                        ExceptionUtils.logRootCause((Throwable)exception);
                        ServiceError error = new ServiceError(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage());
                        this.setError(routingContext, error, null);
                    }
                }
            });
        });
        return router;
    }

    private void setError(RoutingContext routingContext, ServiceError error, Future<Object> blockingCodeHandler) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().add(error);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        if (routingContext.getBodyAsJson() != null) {
            try {
                JsonNode reqNode = this.objectMapper.readTree(routingContext.getBodyAsJson().toString());
                errorResponse.setId(reqNode.path("id").asText());
                errorResponse.setVersion(reqNode.path("version").asText());
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
        try {
            routingContext.response().setStatusCode(200).end(this.objectMapper.writeValueAsString((Object)errorResponse));
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)e.getMessage());
        }
        LOGGER.error((Object)error.getMessage());
        if (blockingCodeHandler != null) {
            blockingCodeHandler.fail(error.getMessage());
        }
    }
}

