/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.constant;

public enum VIDGeneratorErrorCode {
    VID_NOT_AVAILABLE("KER-VID-001", "VID not available for allocation"),
    VID_EXPIRY_DATE_EMPTY("KER-VID-002", "Vid expiry date is empty"),
    VID_EXPIRY_DATE_INVALID("KER-VID-003", "Vid expiry date is before current utc time"),
    VID_EXPIRY_DATE_PATTERN_INVALID("KER-VID-004", "Vid expiry date pattern is invalid, should be in yyyy-MM-dd'T'HH:mm:ss.SSS'Z' pattern"),
    INTERNAL_SERVER_ERROR("KER-VID-005", "Internal Server Error"),
    CONFIG_SERVER_FETCH_FAILED("KER-VID-006", "Error in retrieving from config server");

    private final String errorCode;
    private final String errorMessage;

    private VIDGeneratorErrorCode(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

