/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.uingenerator.service.impl;

import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.uingenerator.constant.UinGeneratorErrorCode;
import io.mosip.kernel.uingenerator.dto.UinResponseDto;
import io.mosip.kernel.uingenerator.dto.UinStatusUpdateReponseDto;
import io.mosip.kernel.uingenerator.entity.BaseEntity;
import io.mosip.kernel.uingenerator.entity.UinEntity;
import io.mosip.kernel.uingenerator.exception.UinNotFoundException;
import io.mosip.kernel.uingenerator.exception.UinNotIssuedException;
import io.mosip.kernel.uingenerator.exception.UinStatusNotFoundException;
import io.mosip.kernel.uingenerator.repository.UinRepository;
import io.mosip.kernel.uingenerator.repository.UinRepositoryAssigned;
import io.mosip.kernel.uingenerator.service.UinService;
import io.mosip.kernel.uingenerator.util.UINMetaDataUtil;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UinServiceImpl
implements UinService {
    private Logger LOGGER = LoggerFactory.getLogger(UinServiceImpl.class);
    @Autowired
    private UinRepository uinRepository;
    @Autowired
    private UinRepositoryAssigned uinRepositoryAssigned;
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private UINMetaDataUtil metaDataUtil;

    @Transactional
    public UinResponseDto getUin() {
        UinResponseDto uinResponseDto = new UinResponseDto();
        UinEntity uinBean = this.uinRepository.findFirstByStatus("UNUSED");
        if (uinBean == null) {
            throw new UinNotFoundException(UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorMessage());
        }
        this.uinRepository.updateStatus("ISSUED", "defaultadmin@mosip.io", DateUtils.getUTCCurrentDateTime(), uinBean.getUin());
        uinResponseDto.setUin(uinBean.getUin());
        return uinResponseDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UinStatusUpdateReponseDto updateUinStatus(UinEntity uinAck) {
        UinStatusUpdateReponseDto uinResponseDto = new UinStatusUpdateReponseDto();
        UinEntity existingUin = this.uinRepository.findByUin(uinAck.getUin());
        if (existingUin == null) throw new UinNotFoundException(UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_FOUND.getErrorMessage());
        if (!"ISSUED".equals(existingUin.getStatus())) throw new UinNotIssuedException(UinGeneratorErrorCode.UIN_NOT_ISSUED.getErrorCode(), UinGeneratorErrorCode.UIN_NOT_ISSUED.getErrorMessage());
        this.metaDataUtil.setUpdateMetaData((BaseEntity)existingUin);
        if ("ASSIGNED".equals(uinAck.getStatus())) {
            existingUin.setStatus("ASSIGNED");
            this.uinRepository.save((Object)existingUin);
        } else {
            if (!"UNASSIGNED".equals(uinAck.getStatus())) throw new UinStatusNotFoundException(UinGeneratorErrorCode.UIN_STATUS_NOT_FOUND.getErrorCode(), UinGeneratorErrorCode.UIN_STATUS_NOT_FOUND.getErrorMessage());
            existingUin.setStatus("UNUSED");
            this.uinRepository.save((Object)existingUin);
        }
        uinResponseDto.setUin(existingUin.getUin());
        uinResponseDto.setStatus(existingUin.getStatus());
        return uinResponseDto;
    }

    @Transactional(transactionManager="transactionManager")
    public void transferUin() {
        List uinEntities = this.uinRepository.findByStatus("ASSIGNED");
        List uinEntitiesAssined = (List)this.modelMapper.map((Object)uinEntities, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.uinRepositoryAssigned.saveAll((Iterable)uinEntitiesAssined);
        this.uinRepository.deleteAll((Iterable)uinEntities);
    }

    public boolean uinExist(String uin) {
        Optional uinEntityAssignedOptional = this.uinRepositoryAssigned.findById((Object)uin);
        return uinEntityAssignedOptional.isPresent();
    }
}

