/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator;

import io.mosip.kernel.core.templatemanager.spi.TemplateManager;
import io.mosip.kernel.core.util.FileUtils;
import io.mosip.kernel.idgenerator.config.ConfigUrlsBuilder;
import io.mosip.kernel.idgenerator.config.HibernateDaoConfig;
import io.mosip.kernel.templatemanager.velocity.builder.TemplateManagerBuilderImpl;
import io.mosip.kernel.uingenerator.verticle.UinGeneratorVerticle;
import io.mosip.kernel.uingenerator.verticle.UinTransferVerticle;
import io.mosip.kernel.vidgenerator.verticle.VidExpiryVerticle;
import io.mosip.kernel.vidgenerator.verticle.VidPoolCheckerVerticle;
import io.mosip.kernel.vidgenerator.verticle.VidPopulatorVerticle;
import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class IDGeneratorVertxApplication {
    private static Vertx vertx;
    private static Logger LOGGER;
    @Value(value="${server.servlet.path}")
    private String contextPath;

    @PostConstruct
    private void swaggerJSONFileUpdate() {
        try {
            File swaggerJsonnFile = new File("swagger-ui/swagger.json");
            TemplateManager templateManager = new TemplateManagerBuilderImpl().build();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("servletpath", this.contextPath);
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("swagger-template.vm");
            InputStream out = templateManager.merge(is, map);
            String merged = IOUtils.toString((InputStream)out, (String)StandardCharsets.UTF_8.name());
            FileUtils.writeStringToFile((File)swaggerJsonnFile, (String)merged, (String)StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage());
        }
    }

    @PostConstruct
    private static void initVIDPool() {
        LOGGER.info((Object)"Service will be started after pooling vids..");
        EventBus eventBus = vertx.eventBus();
        LOGGER.info((Object)"eventBus deployer {}", new Object[]{eventBus});
        eventBus.publish("INIT_POOL", (Object)"INIT_POOL");
    }

    public static void main(String[] args) {
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        LOGGER = LoggerFactory.getLogger(IDGeneratorVertxApplication.class);
        IDGeneratorVertxApplication.loadPropertiesFromConfigServer();
    }

    private static void loadPropertiesFromConfigServer() {
        Vertx vertx = Vertx.vertx();
        try {
            ArrayList configStores = new ArrayList();
            List configUrls = ConfigUrlsBuilder.getURLs();
            configUrls.forEach(url -> configStores.add(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", url).put("timeout", Long.valueOf(Long.parseLong("180000"))))));
            ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions();
            configStores.forEach(arg_0 -> ((ConfigRetrieverOptions)configRetrieverOptions).addStore(arg_0));
            ConfigRetriever retriever = ConfigRetriever.create((Vertx)vertx, (ConfigRetrieverOptions)configRetrieverOptions.setScanPeriod(0L));
            LOGGER.info((Object)"Retrieving configuration from Spring-Config-Server");
            retriever.getConfig(json -> {
                if (json.succeeded()) {
                    JsonObject jsonObject = (JsonObject)json.result();
                    if (jsonObject != null) {
                        jsonObject.iterator().forEachRemaining(sourceValue -> System.setProperty((String)sourceValue.getKey(), sourceValue.getValue().toString()));
                    }
                    json.mapEmpty();
                    retriever.close();
                    vertx.close();
                    IDGeneratorVertxApplication.startApplication();
                } else {
                    LOGGER.warn((Object)(json.cause().getMessage() + "\n"));
                    json.otherwiseEmpty();
                    retriever.close();
                    vertx.close();
                    IDGeneratorVertxApplication.startApplication();
                }
            });
        }
        catch (Exception exception) {
            LOGGER.warn((Object)(exception.getMessage() + "\n"));
            vertx.close();
            IDGeneratorVertxApplication.startApplication();
        }
    }

    private static void startApplication() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{HibernateDaoConfig.class});
        VertxOptions options = new VertxOptions();
        options.setMetricsOptions((MetricsOptions)new MicrometerMetricsOptions().setPrometheusOptions(new VertxPrometheusOptions().setEnabled(true)).setEnabled(true));
        DeploymentOptions workerOptions = new DeploymentOptions().setWorker(true);
        vertx = Vertx.vertx((VertxOptions)options);
        Verticle[] workerVerticles = new Verticle[]{new VidPoolCheckerVerticle((ApplicationContext)context), new VidPopulatorVerticle((ApplicationContext)context), new VidExpiryVerticle((ApplicationContext)context)};
        Stream.of(workerVerticles).forEach(verticle -> IDGeneratorVertxApplication.deploy((Verticle)verticle, (DeploymentOptions)workerOptions, (Vertx)vertx));
        vertx.setTimer(1000L, handler -> IDGeneratorVertxApplication.initVIDPool());
        Verticle[] uinVerticles = new Verticle[]{new UinGeneratorVerticle((ApplicationContext)context), new UinTransferVerticle((ApplicationContext)context)};
        Stream.of(uinVerticles).forEach(verticle -> vertx.deployVerticle(verticle, stringAsyncResult -> {
            if (stringAsyncResult.succeeded()) {
                LOGGER.info((Object)("Successfully deployed: " + verticle.getClass().getSimpleName()));
            } else {
                LOGGER.info((Object)("Failed to deploy:" + verticle.getClass().getSimpleName() + "\nCause: " + stringAsyncResult.cause()));
            }
        }));
        vertx.setTimer(1000L, handler -> IDGeneratorVertxApplication.initUINPool());
    }

    @PostConstruct
    private static void initUINPool() {
        LOGGER.info((Object)"Service will be started after pooling vids..");
        EventBus eventBus = vertx.eventBus();
        LOGGER.info((Object)"eventBus deployer {}", new Object[]{eventBus});
        eventBus.publish("UIN_GENERATOR_ADDRESS", (Object)"GENERATE_UIN");
    }

    private static void deploy(Verticle verticle, DeploymentOptions opts, Vertx vertx) {
        vertx.deployVerticle(verticle, opts, res -> {
            if (res.failed()) {
                LOGGER.info((Object)("Failed to deploy verticle " + verticle.getClass().getSimpleName() + " " + res.cause()));
            } else if (res.succeeded()) {
                LOGGER.info((Object)("Deployed verticle " + verticle.getClass().getSimpleName()));
            }
        });
    }
}

