/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.vidgenerator.service.impl;

import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.vidgenerator.constant.VIDGeneratorErrorCode;
import io.mosip.kernel.vidgenerator.dto.VidFetchResponseDto;
import io.mosip.kernel.vidgenerator.entity.BaseEntity;
import io.mosip.kernel.vidgenerator.entity.VidEntity;
import io.mosip.kernel.vidgenerator.exception.VidGeneratorServiceException;
import io.mosip.kernel.vidgenerator.repository.VidRepository;
import io.mosip.kernel.vidgenerator.service.VidService;
import io.mosip.kernel.vidgenerator.utils.ExceptionUtils;
import io.mosip.kernel.vidgenerator.utils.VIDMetaDataUtil;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VidServiceImpl
implements VidService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VidServiceImpl.class);
    @Value(value="${mosip.kernel.vid.time-to-renew-after-expiry}")
    private long timeToRenewAfterExpiry;
    @Autowired
    private VidRepository vidRepository;
    @Autowired
    private VIDMetaDataUtil metaDataUtil;

    @Transactional
    public VidFetchResponseDto fetchVid(LocalDateTime vidExpiry) {
        VidFetchResponseDto vidFetchResponseDto = new VidFetchResponseDto();
        VidEntity vidEntity = null;
        try {
            vidEntity = this.vidRepository.findFirstByStatus("AVAILABLE");
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
        }
        if (vidEntity != null) {
            if (vidExpiry != null) {
                vidEntity.setVidExpiry(vidExpiry);
            }
            vidFetchResponseDto.setVid(vidEntity.getVid());
            try {
                this.vidRepository.updateVid("ASSIGNED", "defaultadmin@mosip.io", DateUtils.getUTCCurrentDateTime(), vidEntity.getVid());
            }
            catch (DataAccessException exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
            }
            catch (Exception exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                throw new VidGeneratorServiceException(VIDGeneratorErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception.getCause());
            }
        } else {
            LOGGER.info((Object)"vid not available");
            throw new VidGeneratorServiceException(VIDGeneratorErrorCode.VID_NOT_AVAILABLE.getErrorCode(), VIDGeneratorErrorCode.VID_NOT_AVAILABLE.getErrorMessage());
        }
        return vidFetchResponseDto;
    }

    public long fetchVidCount(String status) {
        long vidCount = 0L;
        try {
            vidCount = this.vidRepository.countByStatusAndIsDeletedFalse(status);
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        return vidCount;
    }

    public void expireAndRenew() {
        try {
            List vidAssignedEntities = this.vidRepository.findByStatusAndIsDeletedFalse("ASSIGNED");
            vidAssignedEntities.forEach(arg_0 -> this.expireIfEligible(arg_0));
            this.vidRepository.saveAll((Iterable)vidAssignedEntities);
            List vidExpiredEntities = this.vidRepository.findByStatusAndIsDeletedFalse("EXPIRED");
            vidExpiredEntities.forEach(arg_0 -> this.renewIfEligible(arg_0));
            this.vidRepository.saveAll((Iterable)vidExpiredEntities);
        }
        catch (DataAccessException exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
        catch (Exception exception) {
            LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
        }
    }

    private void expireIfEligible(VidEntity entity) {
        LocalDateTime currentTime = DateUtils.getUTCCurrentDateTime();
        LOGGER.debug((Object)"currenttime {} for checking entity with expiry time {}", new Object[]{currentTime, entity.getVidExpiry()});
        if ((entity.getVidExpiry().isBefore(currentTime) || entity.getVidExpiry().isEqual(currentTime)) && entity.getStatus().equals("ASSIGNED")) {
            this.metaDataUtil.setUpdateMetaData((BaseEntity)entity);
            entity.setStatus("EXPIRED");
        }
    }

    private void renewIfEligible(VidEntity entity) {
        LocalDateTime currentTime = DateUtils.getUTCCurrentDateTime();
        LocalDateTime renewElegibleTime = entity.getVidExpiry().plusDays(this.timeToRenewAfterExpiry);
        LOGGER.debug((Object)"currenttime {} for checking entity with renew elegible time {}", new Object[]{currentTime, renewElegibleTime});
        if ((renewElegibleTime.isBefore(currentTime) || renewElegibleTime.isEqual(currentTime)) && entity.getStatus().equals("EXPIRED")) {
            entity.setVidExpiry(null);
            this.metaDataUtil.setUpdateMetaData((BaseEntity)entity);
            entity.setStatus("AVAILABLE");
        }
    }

    public boolean saveVID(VidEntity vid) {
        if (!this.vidRepository.existsById((Object)vid.getVid())) {
            try {
                this.vidRepository.saveAndFlush((Object)vid);
            }
            catch (DataAccessException exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                return false;
            }
            catch (Exception exception) {
                LOGGER.error((Object)ExceptionUtils.parseException((Throwable)exception));
                return false;
            }
            return true;
        }
        return false;
    }
}

