/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.verticle;

import io.mosip.kernel.idgenerator.config.UinServiceRouter;
import io.mosip.kernel.vidgenerator.router.VidFetcherRouter;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.micrometer.PrometheusScrapingHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class HttpServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServerVerticle.class);
    private Environment environment;
    private VidFetcherRouter vidFetcherRouter;
    private UinServiceRouter uinServiceRouter;

    public HttpServerVerticle(ApplicationContext context) {
        this.vidFetcherRouter = (VidFetcherRouter)context.getBean("vidFetcherRouter");
        this.uinServiceRouter = (UinServiceRouter)context.getBean("uinServiceRouter");
        this.environment = context.getEnvironment();
    }

    public void start(Future<Void> future) {
        HttpServer httpServer = this.vertx.createHttpServer();
        Router parentRouter = Router.router((Vertx)this.vertx);
        Router metricRouter = Router.router((Vertx)this.vertx);
        metricRouter.route("/metrics").handler(PrometheusScrapingHandler.create());
        parentRouter.route().consumes("application/json").produces("application/json");
        parentRouter.mountSubRouter(this.environment.getProperty("server.servlet.path") + "/vid", this.vidFetcherRouter.createRouter(this.vertx));
        parentRouter.mountSubRouter(this.environment.getProperty("server.servlet.path") + "/uin", this.uinServiceRouter.createRouter(this.vertx));
        parentRouter.mountSubRouter(this.environment.getProperty("server.servlet.path"), metricRouter);
        httpServer.requestHandler((Handler)parentRouter);
        httpServer.listen(Integer.parseInt(this.environment.getProperty("server.port")), result -> {
            if (result.succeeded()) {
                LOGGER.debug((Object)"vid fetcher verticle deployed");
                this.vertx.eventBus().publish("CHECK_POOL", (Object)"CHECK_POOL");
                future.complete();
            } else if (result.failed()) {
                LOGGER.error((Object)"vid fetcher verticle deployment failed with cause ", result.cause());
                future.fail(result.cause());
            }
        });
    }
}

