/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.rid.impl;

import io.mosip.kernel.core.dataaccess.exception.DataAccessLayerException;
import io.mosip.kernel.core.idgenerator.spi.RidGenerator;
import io.mosip.kernel.core.util.MathUtils;
import io.mosip.kernel.idgenerator.rid.constant.RidGeneratorExceptionConstant;
import io.mosip.kernel.idgenerator.rid.constant.RidGeneratorPropertyConstant;
import io.mosip.kernel.idgenerator.rid.entity.Rid;
import io.mosip.kernel.idgenerator.rid.exception.EmptyInputException;
import io.mosip.kernel.idgenerator.rid.exception.InputLengthException;
import io.mosip.kernel.idgenerator.rid.exception.NullValueException;
import io.mosip.kernel.idgenerator.rid.exception.RidException;
import io.mosip.kernel.idgenerator.rid.repository.RidRepository;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class RidGeneratorImpl
implements RidGenerator<String> {
    @Value(value="${mosip.kernel.registrationcenterid.length:-1}")
    private int centerIdLength;
    @Value(value="${mosip.kernel.machineid.length:-1}")
    private int machineIdLength;
    @Value(value="${mosip.kernel.rid.sequence-length:-1}")
    private int sequenceLength;
    @Value(value="${mosip.kernel.rid.timestamp-length:-1}")
    private int timeStampLength;
    @Value(value="${mosip.kernel.rid.sequence-initial-value:1}")
    private int sequenceInitialValue;
    @Autowired
    RidRepository ridRepository;

    public String generateId(String centreId, String machineId) {
        this.validateInput(centreId, machineId, this.centerIdLength, this.machineIdLength, this.timeStampLength);
        String randomDigitRid = this.sequenceNumberGenerator(this.sequenceLength);
        return this.appendString(randomDigitRid, this.getcurrentTimeStamp(), centreId, machineId);
    }

    public String generateId(String centreId, String machineId, int centerIdLength, int machineIdLength, int sequenceLength, int timeStampLength) {
        this.validateInput(centreId, machineId, centerIdLength, machineIdLength, timeStampLength);
        String randomDigitRid = this.sequenceNumberGenerator(sequenceLength);
        return this.appendString(randomDigitRid, this.getcurrentTimeStamp(), centreId, machineId);
    }

    private void validateInput(String centreId, String machineId, int centerIdLength, int machineIdLength, int timeStampLength) {
        if (centerIdLength <= 0 || machineIdLength <= 0 || timeStampLength <= 0) {
            throw new InputLengthException(RidGeneratorExceptionConstant.INVALID_CENTERID_OR_MACHINEID_TIMESTAMP_LENGTH.getErrorCode(), RidGeneratorExceptionConstant.INVALID_CENTERID_OR_MACHINEID_TIMESTAMP_LENGTH.getErrorMessage());
        }
        if (centreId == null || machineId == null) {
            throw new NullValueException(RidGeneratorExceptionConstant.NULL_VALUE_ERROR_CODE.getErrorCode(), RidGeneratorExceptionConstant.NULL_VALUE_ERROR_CODE.getErrorMessage());
        }
        if (centreId.isEmpty() || machineId.isEmpty()) {
            throw new EmptyInputException(RidGeneratorExceptionConstant.EMPTY_INPUT_ERROR_CODE.getErrorCode(), RidGeneratorExceptionConstant.EMPTY_INPUT_ERROR_CODE.getErrorMessage());
        }
        if (centreId.length() != centerIdLength || machineId.length() != machineIdLength) {
            throw new InputLengthException(RidGeneratorExceptionConstant.INPUT_LENGTH_ERROR_CODE.getErrorCode(), RidGeneratorExceptionConstant.INPUT_LENGTH_ERROR_CODE.getErrorMessage());
        }
    }

    private String sequenceNumberGenerator(int sequenceLength) {
        int sequenceId = 0;
        Rid entity = null;
        int sequenceEndvalue = MathUtils.getPow((int)10, (int)sequenceLength) - 1;
        String sequenceFormat = "%0" + sequenceLength + "d";
        if (sequenceLength <= 0) {
            throw new InputLengthException(RidGeneratorExceptionConstant.INVALID_SEQ_LENGTH_EXCEPTION.getErrorCode(), RidGeneratorExceptionConstant.INVALID_SEQ_LENGTH_EXCEPTION.getErrorMessage());
        }
        try {
            entity = this.ridRepository.findLastRid();
        }
        catch (DataAccessLayerException | DataAccessException e) {
            throw new RidException(RidGeneratorExceptionConstant.RID_FETCH_EXCEPTION.getErrorCode(), RidGeneratorExceptionConstant.RID_FETCH_EXCEPTION.errorMessage, e);
        }
        try {
            if (entity == null) {
                entity = new Rid();
                sequenceId = this.sequenceInitialValue;
                entity.setCurrentSequenceNo(this.sequenceInitialValue);
                entity.setCreatedBy("SYSTEM");
                entity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                this.ridRepository.save(entity);
            } else {
                entity.setUpdatedBy("SYSTEM");
                entity.setUpdatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                if (entity.getCurrentSequenceNo() == sequenceEndvalue) {
                    sequenceId = this.sequenceInitialValue;
                    this.ridRepository.updateRid(this.sequenceInitialValue, entity.getCurrentSequenceNo());
                } else {
                    sequenceId = entity.getCurrentSequenceNo() + 1;
                    this.ridRepository.updateRid(sequenceId, entity.getCurrentSequenceNo());
                }
            }
        }
        catch (DataAccessLayerException | DataAccessException e) {
            throw new RidException(RidGeneratorExceptionConstant.RID_UPDATE_EXCEPTION.getErrorCode(), RidGeneratorExceptionConstant.RID_UPDATE_EXCEPTION.errorMessage, e);
        }
        return String.format(sequenceFormat, sequenceId);
    }

    private String appendString(String randomDigitRid, String currentTimeStamp, String centreId, String dongleId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(centreId).append(dongleId).append(randomDigitRid).append(currentTimeStamp);
        return stringBuilder.toString().trim();
    }

    private String getcurrentTimeStamp() {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(RidGeneratorPropertyConstant.TIMESTAMP_FORMAT.getProperty());
        return LocalDateTime.now(ZoneId.of("UTC")).format(format);
    }
}

