/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.regcenterid.impl;

import io.mosip.kernel.core.dataaccess.exception.DataAccessLayerException;
import io.mosip.kernel.core.idgenerator.spi.RegistrationCenterIdGenerator;
import io.mosip.kernel.core.util.MathUtils;
import io.mosip.kernel.idgenerator.regcenterid.constant.RegistrationCenterIdConstant;
import io.mosip.kernel.idgenerator.regcenterid.entity.RegistrationCenterId;
import io.mosip.kernel.idgenerator.regcenterid.exception.RegistrationCenterIdServiceException;
import io.mosip.kernel.idgenerator.regcenterid.repository.RegistrationCenterIdRepository;
import jakarta.persistence.EntityExistsException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RegistrationCenterIdGeneratorImpl
implements RegistrationCenterIdGenerator<String> {
    @Value(value="${mosip.kernel.registrationcenterid.length}")
    private int registrationCenterIdLength;
    @Autowired
    RegistrationCenterIdRepository registrationCenterIdRepository;

    public String generateRegistrationCenterId() {
        int generatedRCID = 0;
        int initialValue = MathUtils.getPow((int)RegistrationCenterIdConstant.ID_BASE.getValue(), (int)(this.registrationCenterIdLength - 1));
        RegistrationCenterId registrationCenterId = null;
        try {
            registrationCenterId = this.registrationCenterIdRepository.findLastRCID();
        }
        catch (DataAccessLayerException dataAccessLayerException) {
            throw new RegistrationCenterIdServiceException(RegistrationCenterIdConstant.REG_CEN_ID_FETCH_EXCEPTION.getErrorCode(), RegistrationCenterIdConstant.REG_CEN_ID_FETCH_EXCEPTION.getErrorMessage(), dataAccessLayerException.getCause());
        }
        try {
            if (registrationCenterId == null) {
                registrationCenterId = new RegistrationCenterId();
                registrationCenterId.setRcid(initialValue);
                generatedRCID = initialValue;
                registrationCenterId.setCreatedBy("SYSTEM");
                registrationCenterId.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                registrationCenterId.setUpdatedBy("SYSTEM");
                registrationCenterId.setUpdatedDateTime(null);
                this.registrationCenterIdRepository.create(registrationCenterId);
            } else {
                generatedRCID = registrationCenterId.getRcid() + 1;
                RegistrationCenterId entity = new RegistrationCenterId();
                entity.setRcid(generatedRCID);
                entity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                entity.setUpdatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                entity.setUpdatedBy("SYSTEM");
                entity.setCreatedBy("SYSTEM");
                this.registrationCenterIdRepository.create(entity);
            }
        }
        catch (DataAccessLayerException e) {
            if (e.getCause().getClass() == EntityExistsException.class) {
                this.generateRegistrationCenterId();
            }
            throw new RegistrationCenterIdServiceException(RegistrationCenterIdConstant.REG_CEN_ID_INSERT_EXCEPTION.getErrorCode(), RegistrationCenterIdConstant.REG_CEN_ID_INSERT_EXCEPTION.getErrorMessage(), e);
        }
        return String.valueOf(generatedRCID);
    }
}

