/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.prid.util;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PridFilterUtils {
    @Value(value="#{'${mosip.kernel.prid.restricted-numbers}'.split(',')}")
    private List<String> restrictedAdminDigits;
    @Value(value="${mosip.kernel.prid.sequence-limit}")
    private int sequenceLimit;
    @Value(value="${mosip.kernel.prid.repeating-block-limit}")
    private int repeatingBlockLimit;
    @Value(value="${mosip.kernel.prid.repeating-limit}")
    private int repeatingLimit;
    @Value(value="#{'${mosip.kernel.prid.not-start-with}'.split(',')}")
    private List<String> notStartWith;
    @Value(value="${mosip.kernel.prid.length}")
    private int pridLength;
    private static final String SEQ_ASC = "0123456789";
    private static final String SEQ_DEC = "9876543210";
    private Pattern repeatingPattern = null;
    private Pattern repeatingBlockpattern = null;

    @PostConstruct
    public void initializeRegEx() {
        if (this.repeatingLimit > 0) {
            String repeatingRegEx = "(\\d)\\d{0," + (this.repeatingLimit - 1) + "}\\1";
            this.repeatingPattern = Pattern.compile(repeatingRegEx);
        }
        if (this.repeatingBlockLimit > 0) {
            String repeatingBlockRegex = "(\\d{" + this.repeatingBlockLimit + ",}).*?\\1";
            this.repeatingBlockpattern = Pattern.compile(repeatingBlockRegex);
        }
    }

    public boolean isValidId(String id) {
        return !this.sequenceFilter(id) && !PridFilterUtils.regexFilter(id, this.repeatingPattern) && !PridFilterUtils.regexFilter(id, this.repeatingBlockpattern) && !this.validateNotStartWith(id) && !this.validateIdLength(id) && !this.restrictedAdminFilter(id);
    }

    private boolean restrictedAdminFilter(String id) {
        return this.restrictedAdminDigits.parallelStream().anyMatch(id::contains);
    }

    private boolean sequenceFilter(String id) {
        if (this.sequenceLimit > 0) {
            return IntStream.rangeClosed(0, id.length() - this.sequenceLimit).parallel().mapToObj(index -> id.subSequence(index, index + this.sequenceLimit)).anyMatch(idSubSequence -> SEQ_ASC.contains((CharSequence)idSubSequence) || SEQ_DEC.contains((CharSequence)idSubSequence));
        }
        return false;
    }

    private static boolean regexFilter(String id, Pattern pattern) {
        if (pattern != null) {
            return pattern.matcher(id).find();
        }
        return false;
    }

    private boolean validateNotStartWith(String id) {
        if (this.notStartWith != null && !this.notStartWith.isEmpty()) {
            for (String str : this.notStartWith) {
                if (!id.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateIdLength(String id) {
        return id.length() != this.pridLength;
    }
}

