/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.prid.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.idgenerator.spi.PridGenerator;
import io.mosip.kernel.core.util.ChecksumUtils;
import io.mosip.kernel.idgenerator.prid.constant.PridPropertyConstant;
import io.mosip.kernel.idgenerator.prid.util.PridFilterUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.PostConstruct;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PridGeneratorImpl
implements PridGenerator<String> {
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    boolean init = true;
    private String randomSeed;
    private String counter;
    @Autowired
    PridFilterUtils pridFilterUtils;
    @Value(value="${mosip.kernel.prid.length}")
    private int pridLength;

    @PostConstruct
    private void init() {
        this.randomSeed = RandomStringUtils.random((int)Integer.parseInt(PridPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)PridPropertyConstant.ZERO_TO_NINE.getProperty());
        do {
            this.counter = RandomStringUtils.random((int)Integer.parseInt(PridPropertyConstant.RANDOM_NUMBER_SIZE.getProperty()), (String)PridPropertyConstant.ZERO_TO_NINE.getProperty());
        } while (this.counter.charAt(0) == '0');
    }

    public String generateId() {
        String generatedVid = this.generateRandomId();
        while (!this.pridFilterUtils.isValidId(generatedVid) || generatedVid.contains(" ")) {
            generatedVid = this.generateRandomId();
        }
        return generatedVid;
    }

    private String generateRandomId() {
        String prid = null;
        this.counter = this.init ? this.counter : new BigInteger(this.counter).add(BigInteger.ONE).toString();
        this.init = false;
        SecretKeySpec secretKey = new SecretKeySpec(this.counter.getBytes(), PridPropertyConstant.ENCRYPTION_ALGORITHM.getProperty());
        byte[] encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)this.randomSeed.getBytes(), null);
        BigInteger bigInteger = new BigInteger(encryptedData);
        prid = String.valueOf(bigInteger.abs());
        prid = prid.substring(0, this.pridLength - 1);
        String verhoeffDigit = ChecksumUtils.generateChecksumDigit((String)prid);
        return this.appendChecksum(prid, verhoeffDigit);
    }

    private String appendChecksum(String generatedPrid, String verhoeffDigit) {
        StringBuilder pridStringbuilder = new StringBuilder();
        pridStringbuilder.setLength(this.pridLength);
        return pridStringbuilder.insert(0, generatedPrid).insert(generatedPrid.length(), verhoeffDigit).toString().trim();
    }
}

