/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.idgenerator.machineid.impl;

import io.mosip.kernel.core.dataaccess.exception.DataAccessLayerException;
import io.mosip.kernel.core.idgenerator.spi.MachineIdGenerator;
import io.mosip.kernel.core.util.MathUtils;
import io.mosip.kernel.idgenerator.machineid.constant.MachineIdConstant;
import io.mosip.kernel.idgenerator.machineid.entity.MachineId;
import io.mosip.kernel.idgenerator.machineid.exception.MachineIdServiceException;
import io.mosip.kernel.idgenerator.machineid.repository.MachineIdRepository;
import jakarta.persistence.EntityExistsException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MachineIdGeneratorImpl
implements MachineIdGenerator<String> {
    @Value(value="${mosip.kernel.machineid.length}")
    private int machineIdLength;
    @Autowired
    private MachineIdRepository machineIdRepository;

    public String generateMachineId() {
        int generatedMID = 0;
        int initialValue = MathUtils.getPow((int)MachineIdConstant.ID_BASE.getValue(), (int)(this.machineIdLength - 1));
        MachineId machineId = null;
        try {
            machineId = this.machineIdRepository.findLastMID();
        }
        catch (DataAccessLayerException dataAccessLayerException) {
            throw new MachineIdServiceException(MachineIdConstant.MID_FETCH_EXCEPTION.getErrorCode(), MachineIdConstant.MID_FETCH_EXCEPTION.getErrorMessage(), dataAccessLayerException.getCause());
        }
        try {
            if (machineId == null) {
                machineId = new MachineId();
                machineId.setMId(initialValue);
                machineId.setCreatedBy("SYSTEM");
                machineId.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                machineId.setUpdatedBy("SYSTEM");
                machineId.setUpdatedDateTime(null);
                generatedMID = initialValue;
                this.machineIdRepository.create(machineId);
            } else {
                generatedMID = machineId.getMId() + 1;
                MachineId entity = new MachineId();
                entity.setMId(generatedMID);
                entity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                entity.setUpdatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                entity.setUpdatedBy("SYSTEM");
                entity.setCreatedBy("SYSTEM");
                this.machineIdRepository.create(entity);
            }
        }
        catch (DataAccessLayerException e) {
            if (e.getCause().getClass() == EntityExistsException.class) {
                this.generateMachineId();
            }
            throw new MachineIdServiceException(MachineIdConstant.MID_INSERT_EXCEPTION.getErrorCode(), MachineIdConstant.MID_INSERT_EXCEPTION.getErrorMessage(), e);
        }
        return String.valueOf(generatedMID);
    }
}

