/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.fsadapter.hdfs.util;

import io.mosip.kernel.core.fsadapter.exception.FSAdapterException;
import io.mosip.kernel.fsadapter.hdfs.constant.HDFSAdapterErrorCode;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class ConnectionUtils {
    @Value(value="${mosip.kernel.fsadapter.hdfs.name-node-url}")
    private String nameNodeUrl;
    @Value(value="${mosip.kernel.fsadapter.hdfs.kdc-domain:NOTSET}")
    private String kdcDomain;
    @Value(value="${mosip.kernel.fsadapter.hdfs.user-name}")
    private String userName;
    @Value(value="${mosip.kernel.fsadapter.hdfs.authentication-enabled:false}")
    private boolean isAuthEnable;
    @Value(value="${mosip.kernel.fsadapter.hdfs.keytab-file:NOTSET}")
    private String keytabPath;
    @Value(value="${mosip.kernel.fsadapter.hdfs.connect.timeout:6000}")
    private String connectTimeout;
    @Value(value="${mosip.kernel.fsadapter.hdfs.connect.max.retries.on.timeouts:10}")
    private String maxRetries;
    @Value(value="${mosip.kernel.fsadapter.hdfs.krb-file:classpath:krb5.conf}")
    private String kerberosConfigFile;
    private FileSystem configuredFileSystem;
    @Autowired
    private ResourceLoader resourceLoader;
    private static final String HADOOP_HOME = "hadoop-lib";
    private static final String WIN_UTIL = "winutils.exe";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private Path hadoopLibPath;

    public FileSystem getConfiguredFileSystem() {
        if (this.configuredFileSystem == null) {
            try {
                Configuration configuration = this.prepareConfiguration();
                if (this.isAuthEnable) {
                    configuration = this.initSecurityConfiguration(configuration);
                    this.configuredFileSystem = FileSystem.get((Configuration)configuration);
                } else {
                    this.configuredFileSystem = this.getDefaultConfiguredFileSystem(configuration);
                }
            }
            catch (IOException e) {
                throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
            }
        }
        return this.configuredFileSystem;
    }

    private Configuration initSecurityConfiguration(Configuration configuration) throws IOException {
        configuration.set("dfs.data.transfer.protection", "authentication");
        configuration.set("hadoop.security.authentication", "kerberos");
        Resource configFile = this.resourceLoader.getResource(this.kerberosConfigFile);
        if (configFile.exists()) {
            Path krbPath = Paths.get(this.hadoopLibPath.toString(), "krb5.conf");
            Files.copy(configFile.getInputStream(), krbPath, new CopyOption[0]);
            System.setProperty("java.security.krb5.conf", krbPath.toString());
        }
        UserGroupInformation.setConfiguration((Configuration)configuration);
        String user = this.userName + "@" + this.kdcDomain;
        this.loginWithKeyTab(user, this.keytabPath);
        return configuration;
    }

    private FileSystem getDefaultConfiguredFileSystem(final Configuration configuration) {
        try {
            this.configuredFileSystem = (FileSystem)UserGroupInformation.createRemoteUser((String)this.userName, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.TOKEN).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get((Configuration)configuration);
                }
            });
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return this.configuredFileSystem;
    }

    private Configuration prepareConfiguration() {
        Configuration configuration = null;
        try {
            configuration = new Configuration();
            configuration.set("fs.defaultFS", this.nameNodeUrl);
            configuration.set("dfs.client.use.datanode.hostname", "true");
            configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            configuration.set("ipc.client.connect.timeout", this.connectTimeout);
            configuration.set("ipc.client.connect.max.retries.on.timeouts", this.maxRetries);
            this.hadoopLibPath = Files.createTempDirectory(HADOOP_HOME, new FileAttribute[0]);
            System.setProperty("hadoop.home.dir", this.hadoopLibPath.toString());
            if (SystemUtils.IS_OS_WINDOWS) {
                Path binPath = Files.createDirectory(Paths.get(this.hadoopLibPath.toString(), "bin"), new FileAttribute[0]);
                Resource resource = this.resourceLoader.getResource("classpath:winutils.exe");
                if (resource.exists()) {
                    Path winUtilsPath = Paths.get(binPath.toString(), resource.getFilename());
                    Files.copy(resource.getInputStream(), winUtilsPath, new CopyOption[0]);
                }
            }
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return configuration;
    }

    private void loginWithKeyTab(String user, String keytabPath) throws IOException {
        Path keyPath = null;
        Resource resource = this.resourceLoader.getResource(keytabPath);
        Path dataPath = Files.createDirectory(Paths.get(this.hadoopLibPath.toString(), "data"), new FileAttribute[0]);
        if (!resource.exists()) {
            throw new FSAdapterException(HDFSAdapterErrorCode.KEYTAB_FILE_NOT_FOUND_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.KEYTAB_FILE_NOT_FOUND_EXCEPTION.getErrorMessage() + ": " + keytabPath);
        }
        keyPath = Paths.get(dataPath.toString(), resource.getFilename());
        Files.copy(resource.getInputStream(), keyPath, StandardCopyOption.REPLACE_EXISTING);
        try {
            UserGroupInformation.loginUserFromKeytab((String)user, (String)keyPath.toString());
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.LOGIN_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.LOGIN_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }
}

