/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.fsadapter.hdfs.impl;

import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.fsadapter.exception.FSAdapterException;
import io.mosip.kernel.core.fsadapter.spi.FileSystemAdapter;
import io.mosip.kernel.fsadapter.hdfs.constant.HDFSAdapterErrorCode;
import io.mosip.kernel.fsadapter.hdfs.util.ConnectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HDFSAdapterImpl
implements FileSystemAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HDFSAdapterImpl.class.getName());
    private FileSystem fs;

    public HDFSAdapterImpl(ConnectionUtils connectionUtil) {
        if (this.fs == null) {
            this.fs = connectionUtil.getConfiguredFileSystem();
        }
    }

    public boolean checkFileExistence(String id, String filePath) {
        LOGGER.info("Checking if file exist in packet {} with path {}", (Object)id, (Object)this.getFilePath(filePath));
        Path path = this.getHadoopPath(id, filePath);
        try {
            return this.fs.exists(path);
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public boolean copyFile(String sourcePacket, String sourceFilePath, String destinationPacket, String destinationFilePath) {
        LOGGER.info("Copying file from packet {} with path {} to packet {} with path {}", new Object[]{sourcePacket, sourceFilePath, destinationPacket, destinationFilePath});
        return this.storeFile(destinationPacket, destinationFilePath, this.getFile(sourcePacket, sourceFilePath));
    }

    public boolean deleteFile(String id, String filePath) {
        LOGGER.info("Deleting file in packet {} with path {}", (Object)id, (Object)this.getFilePath(filePath));
        Path path = this.getHadoopPath(id, filePath);
        try {
            return this.fs.delete(path, true);
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public boolean deletePacket(String id) {
        LOGGER.info("Deleting packet {}", (Object)id);
        Path path = this.getHadoopPath(id, id);
        try {
            return this.fs.delete(path, true);
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public InputStream getFile(String id, String filePath) {
        LOGGER.info("Getting file from packet {} with path {}", (Object)id, (Object)this.getFilePath(filePath));
        Path inFile = this.getHadoopPath(id, filePath);
        try {
            if (!this.fs.exists(inFile)) {
                throw new FSAdapterException(HDFSAdapterErrorCode.FILE_NOT_FOUND_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.FILE_NOT_FOUND_EXCEPTION.getErrorMessage());
            }
            return this.fs.open(inFile);
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public InputStream getPacket(String id) {
        LOGGER.info("Getting packet {} ", (Object)id);
        try {
            Path inFile = this.getHadoopPath(id, id);
            if (!this.fs.exists(inFile)) {
                LOGGER.error("Packet " + id + " doesnot exist in filesystem {} ", (Object)HDFSAdapterErrorCode.FILE_NOT_FOUND_EXCEPTION.getErrorMessage());
                throw new FSAdapterException(HDFSAdapterErrorCode.FILE_NOT_FOUND_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.FILE_NOT_FOUND_EXCEPTION.getErrorMessage());
            }
            return this.fs.open(inFile);
        }
        catch (IOException e) {
            LOGGER.error("Packet " + id + " io exceptio occuered", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public boolean isPacketPresent(String id) {
        LOGGER.info("Checking if packet {} exists", (Object)id);
        Path path = this.getHadoopPath(id, id);
        try {
            return this.fs.exists(path);
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public boolean storeFile(String id, String filePath, InputStream content) {
        LOGGER.info("Storing file in packet {} with path {}", (Object)id, (Object)this.getFilePath(filePath));
        Path path = this.getHadoopPath(id, filePath);
        FSDataOutputStream out = null;
        try {
            out = this.fs.create(path);
            IOUtils.copyBytes((InputStream)content, (OutputStream)out, (int)512, (boolean)false);
        }
        catch (IOException e) {
            try {
                throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)out);
        return true;
    }

    public boolean storePacket(String id, File file) {
        LOGGER.info("Storing packet {}", (Object)id);
        Path path = this.getHadoopPath(id, id);
        FSDataOutputStream out = null;
        try {
            out = this.fs.create(path);
            IOUtils.copyBytes((InputStream)FileUtils.openInputStream((File)file), (OutputStream)out, (int)512, (boolean)false);
        }
        catch (IOException e) {
            try {
                throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)out);
        return true;
    }

    public boolean storePacket(String id, InputStream content) {
        LOGGER.info("Storing packet {}", (Object)id);
        Path path = this.getHadoopPath(id, id);
        FSDataOutputStream out = null;
        try {
            out = this.fs.create(path);
            IOUtils.copyBytes((InputStream)content, (OutputStream)out, (int)512, (boolean)false);
        }
        catch (IOException e) {
            try {
                throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)out);
        return true;
    }

    public void unpackPacket(String id) {
        LOGGER.info("Unpacking packet {}", (Object)id);
        InputStream packetStream = this.getPacket(id);
        ZipInputStream zis = new ZipInputStream(packetStream);
        byte[] buffer = new byte[2048];
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = zis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                byte[] file = out.toByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
                String filePath = FilenameUtils.getPathNoEndSeparator((String)ze.getName());
                String fileName = FilenameUtils.getBaseName((String)ze.getName());
                if (!fileName.isEmpty()) {
                    this.storeFile(id, FilenameUtils.concat((String)filePath, (String)fileName), inputStream);
                }
                ((InputStream)inputStream).close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new FSAdapterException(HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorCode(), HDFSAdapterErrorCode.HDFS_ADAPTER_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public Path getHadoopPath(String id, String filePath) {
        return new Path(FilenameUtils.concat((String)this.getFilePath(id), (String)this.getFilePath(filePath)));
    }

    public String getFilePath(String filePath) {
        return filePath.toUpperCase();
    }
}

