/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.crypto.jce.util;

import io.mosip.kernel.core.crypto.spi.JwsSpec;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.springframework.stereotype.Component;

@Component
public class JWSValidation
implements JwsSpec<String, String, X509Certificate, PrivateKey> {
    protected PublicKey publicKey;

    public String jwsSign(String payload, PrivateKey pKey, X509Certificate certificate) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(certificate);
            X509Certificate[] certArray = certList.toArray(new X509Certificate[0]);
            jws.setCertificateChainHeaderValue(certArray);
            jws.setPayload(payload);
            jws.setAlgorithmHeaderValue("RS256");
            jws.setKey((Key)pKey);
            jws.setDoKeyValidation(false);
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean verifySignature(String sign) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(sign);
            List certificateChainHeaderValue = jws.getCertificateChainHeaderValue();
            X509Certificate certificate = (X509Certificate)certificateChainHeaderValue.get(0);
            certificate.checkValidity();
            this.publicKey = certificate.getPublicKey();
            jws.setKey((Key)this.publicKey);
            return jws.verifySignature();
        }
        catch (CertificateException | JoseException e) {
            e.printStackTrace();
            return false;
        }
    }
}

