/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.crypto.jce.core;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidParamSpecException;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.crypto.jce.constant.SecurityExceptionCodeConstant;
import io.mosip.kernel.crypto.jce.util.CryptoUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.security.rsa.RSAPadding;

@Component
public class CryptoCore
implements CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> {
    private static final String RSA_ECB_NO_PADDING = "RSA/ECB/NoPadding";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-key-length:2048}")
    private int asymmetricKeyLength;
    private static final String MGF1 = "MGF1";
    private static final String HASH_ALGO = "SHA-256";
    private static final String AES = "AES";
    @Value(value="${mosip.kernel.crypto.gcm-tag-length:128}")
    private int tagLength;
    @Value(value="${mosip.kernel.crypto.symmetric-algorithm-name:AES/GCM/PKCS5Padding}")
    private String symmetricAlgorithm;
    @Value(value="${mosip.kernel.crypto.asymmetric-algorithm-name:RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING}")
    private String asymmetricAlgorithm;
    @Value(value="${mosip.kernel.crypto.hash-algorithm-name:PBKDF2WithHmacSHA512}")
    private String passwordAlgorithm;
    @Value(value="${mosip.kernel.crypto.sign-algorithm-name:SHA512withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.crypto.hash-symmetric-key-length:256}")
    private int symmetricKeyLength;
    @Value(value="${mosip.kernel.crypto.hash-iteration:100000}")
    private int iterations;
    private SecureRandom secureRandom;
    private SecretKeyFactory secretKeyFactory;
    private Signature signature;

    @PostConstruct
    public void init() {
        this.secureRandom = new SecureRandom();
    }

    public byte[] symmetricEncrypt(SecretKey key, byte[] data, byte[] aad) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            cipher = Cipher.getInstance(this.symmetricAlgorithm);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        byte[] output = null;
        byte[] randomIV = this.generateIV(cipher.getBlockSize());
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), AES);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(this.tagLength, randomIV);
            cipher.init(1, (Key)keySpec, gcmParameterSpec);
            output = new byte[cipher.getOutputSize(data.length) + cipher.getBlockSize()];
            if (aad != null && aad.length != 0) {
                cipher.updateAAD(aad);
            }
            byte[] processData = this.doFinal(data, cipher);
            System.arraycopy(processData, 0, output, 0, processData.length);
            System.arraycopy(randomIV, 0, output, processData.length, randomIV.length);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return output;
    }

    public byte[] symmetricEncrypt(SecretKey key, byte[] data, byte[] iv, byte[] aad) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        if (iv == null) {
            return this.symmetricEncrypt(key, data, aad);
        }
        try {
            cipher = Cipher.getInstance(this.symmetricAlgorithm);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), AES);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(this.tagLength, iv);
            cipher.init(1, (Key)keySpec, gcmParameterSpec);
            if (aad != null && aad.length != 0) {
                cipher.updateAAD(aad);
            }
            return this.doFinal(data, cipher);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParamSpecException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public byte[] symmetricDecrypt(SecretKey key, byte[] data, byte[] aad) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            cipher = Cipher.getInstance(this.symmetricAlgorithm);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        byte[] output = null;
        try {
            byte[] randomIV = Arrays.copyOfRange(data, data.length - cipher.getBlockSize(), data.length);
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), AES);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(this.tagLength, randomIV);
            cipher.init(2, (Key)keySpec, gcmParameterSpec);
            if (aad != null && aad.length != 0) {
                cipher.updateAAD(aad);
            }
            output = this.doFinal(Arrays.copyOf(data, data.length - cipher.getBlockSize()), cipher);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidDataException(SecurityExceptionCodeConstant.MOSIP_INVALID_DATA_LENGTH_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_DATA_LENGTH_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return output;
    }

    public byte[] symmetricDecrypt(SecretKey key, byte[] data, byte[] iv, byte[] aad) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        if (iv == null) {
            return this.symmetricDecrypt(key, data, aad);
        }
        try {
            cipher = Cipher.getInstance(this.symmetricAlgorithm);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), AES);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(this.tagLength, iv);
            cipher.init(2, (Key)keySpec, gcmParameterSpec);
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            return this.doFinal(data, cipher);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParamSpecException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public byte[] asymmetricEncrypt(PublicKey key, byte[] data) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            cipher = Cipher.getInstance(this.asymmetricAlgorithm);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        OAEPParameterSpec oaepParams = new OAEPParameterSpec(HASH_ALGO, MGF1, MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        try {
            cipher.init(1, (Key)key, oaepParams);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParamSpecException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return this.doFinal(data, cipher);
    }

    public byte[] asymmetricDecrypt(PrivateKey key, byte[] data) {
        Cipher cipher;
        Objects.requireNonNull(key, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            cipher = Cipher.getInstance(RSA_ECB_NO_PADDING);
        }
        catch (java.security.NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        try {
            cipher.init(2, key);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        byte[] paddedPlainText = this.doFinal(data, cipher);
        if (paddedPlainText.length < this.asymmetricKeyLength / 8) {
            byte[] tempPipe = new byte[this.asymmetricKeyLength / 8];
            System.arraycopy(paddedPlainText, 0, tempPipe, tempPipe.length - paddedPlainText.length, paddedPlainText.length);
            paddedPlainText = tempPipe;
        }
        OAEPParameterSpec oaepParams = new OAEPParameterSpec(HASH_ALGO, MGF1, MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        return this.unpadOEAPPadding(paddedPlainText, oaepParams);
    }

    private byte[] unpadOEAPPadding(byte[] paddedPlainText, OAEPParameterSpec paramSpec) {
        byte[] unpaddedData = null;
        try {
            RSAPadding padding = RSAPadding.getInstance(4, this.asymmetricKeyLength / 8, new SecureRandom(), paramSpec);
            unpaddedData = padding.unpad(paddedPlainText);
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParamSpecException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new InvalidDataException(SecurityExceptionCodeConstant.MOSIP_INVALID_DATA_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        return unpaddedData;
    }

    public String hash(byte[] data, byte[] salt) {
        SecretKey key;
        CryptoUtils.verifyData(data);
        CryptoUtils.verifyData(salt, SecurityExceptionCodeConstant.SALT_PROVIDED_IS_NULL_OR_EMPTY.getErrorCode(), SecurityExceptionCodeConstant.SALT_PROVIDED_IS_NULL_OR_EMPTY.getErrorMessage());
        char[] convertedData = new String(data).toCharArray();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(convertedData, salt, this.iterations, this.symmetricKeyLength);
        try {
            this.secretKeyFactory = SecretKeyFactory.getInstance(this.passwordAlgorithm);
            key = this.secretKeyFactory.generateSecret(pbeKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidParamSpecException(SecurityExceptionCodeConstant.MOSIP_INVALID_PARAM_SPEC_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return DatatypeConverter.printHexBinary((byte[])key.getEncoded());
    }

    public String sign(byte[] data, PrivateKey privateKey) {
        Objects.requireNonNull(privateKey, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            this.signature = Signature.getInstance(this.signAlgorithm);
            this.signature.initSign(privateKey);
            this.signature.update(data);
            return CryptoUtil.encodeBase64String((byte[])this.signature.sign());
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (SignatureException e) {
            throw new io.mosip.kernel.core.crypto.exception.SignatureException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public boolean verifySignature(byte[] data, String sign, PublicKey publicKey) {
        if (EmptyCheckUtils.isNullEmpty((String)sign)) {
            throw new io.mosip.kernel.core.crypto.exception.SignatureException(SecurityExceptionCodeConstant.MOSIP_SIGNATURE_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_SIGNATURE_EXCEPTION.getErrorMessage());
        }
        Objects.requireNonNull(publicKey, SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorMessage());
        CryptoUtils.verifyData(data);
        try {
            this.signature = Signature.getInstance(this.signAlgorithm);
            this.signature.initVerify(publicKey);
            this.signature.update(data);
            return this.signature.verify(CryptoUtil.decodeBase64((String)sign));
        }
        catch (InvalidKeyException e) {
            throw new io.mosip.kernel.core.crypto.exception.InvalidKeyException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (SignatureException e) {
            throw new io.mosip.kernel.core.crypto.exception.SignatureException(SecurityExceptionCodeConstant.MOSIP_INVALID_KEY_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), SecurityExceptionCodeConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public SecureRandom random() {
        return this.secureRandom;
    }

    private byte[] generateIV(int blockSize) {
        byte[] byteIV = new byte[blockSize];
        this.secureRandom.nextBytes(byteIV);
        return byteIV;
    }

    private byte[] doFinal(byte[] data, Cipher cipher) {
        try {
            return cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidDataException(SecurityExceptionCodeConstant.MOSIP_INVALID_DATA_SIZE_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new InvalidDataException(SecurityExceptionCodeConstant.MOSIP_INVALID_ENCRYPTED_DATA_CORRUPT_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
    }
}

