/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.mosip.kernel.core.util.constant.JsonUtilConstants;
import io.mosip.kernel.core.util.exception.JsonMappingException;
import io.mosip.kernel.core.util.exception.JsonParseException;
import io.mosip.kernel.core.util.exception.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static String javaObjectToJsonString(Object className) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        String outputJson = null;
        try {
            outputJson = objectMapper.writeValueAsString(className);
        }
        catch (com.fasterxml.jackson.core.JsonProcessingException e) {
            throw new JsonProcessingException(JsonUtilConstants.MOSIP_JSON_PROCESSING_EXCEPTION.getErrorCode(), JsonUtilConstants.MOSIP_JSON_PROCESSING_EXCEPTION.getErrorMessage(), e.getCause());
        }
        return outputJson;
    }

    public static Object jsonStringToJavaObject(Class<?> className, String jsonString) throws JsonParseException, JsonMappingException, io.mosip.kernel.core.exception.IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        Object returnObject = null;
        try {
            returnObject = objectMapper.readValue(jsonString, className);
        }
        catch (com.fasterxml.jackson.core.JsonParseException e) {
            throw new JsonParseException(JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (com.fasterxml.jackson.databind.JsonMappingException e) {
            throw new JsonMappingException(JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        return returnObject;
    }

    public static String jsonToJacksonJson(String jsonString, String key) throws io.mosip.kernel.core.exception.IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        return jsonNode.get(key).asText();
    }

    public static List<Object> jsonStringToJavaList(String jsonArray) throws JsonParseException, JsonMappingException, io.mosip.kernel.core.exception.IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        List javaList = null;
        try {
            javaList = (List)objectMapper.readValue(jsonArray, (TypeReference)new TypeReference<List<Object>>(){});
        }
        catch (com.fasterxml.jackson.core.JsonParseException e) {
            throw new JsonParseException(JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (com.fasterxml.jackson.databind.JsonMappingException e) {
            throw new JsonMappingException(JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        return javaList;
    }

    public static Map<String, Object> jsonStringToJavaMap(String jsonString) throws JsonParseException, JsonMappingException, io.mosip.kernel.core.exception.IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        Map javaMap = null;
        try {
            javaMap = (Map)objectMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (com.fasterxml.jackson.core.JsonParseException e) {
            throw new JsonParseException(JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_PARSE_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (com.fasterxml.jackson.databind.JsonMappingException e) {
            throw new JsonMappingException(JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_JSON_MAPPING_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorCode(), JsonUtilConstants.MOSIP_IO_EXCEPTION_ERROR_CODE.getErrorMessage(), e.getCause());
        }
        return javaMap;
    }
}

