/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.security.util;

import io.mosip.kernel.core.security.constants.MosipSecurityExceptionCodeConstants;
import io.mosip.kernel.core.security.constants.MosipSecurityMethod;
import io.mosip.kernel.core.security.exception.MosipInvalidKeyException;
import io.mosip.kernel.core.security.exception.MosipNullKeyException;
import io.mosip.kernel.core.security.exception.MosipNullMethodException;
import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;

public class SecurityUtil {
    private SecurityUtil() {
    }

    public static AsymmetricKeyParameter bytesToPrivateKey(byte[] privateKey) throws MosipInvalidKeyException {
        AsymmetricKeyParameter keyParameter = null;
        try {
            keyParameter = PrivateKeyFactory.createKey((byte[])privateKey);
        }
        catch (NullPointerException e) {
            throw new MosipNullKeyException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_KEY_EXCEPTION);
        }
        catch (ClassCastException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_ASYMMETRIC_PRIVATE_KEY_EXCEPTION);
        }
        catch (IOException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_KEY_CORRUPT_EXCEPTION);
        }
        return keyParameter;
    }

    public static AsymmetricKeyParameter bytesToPublicKey(byte[] publicKey) throws MosipInvalidKeyException {
        AsymmetricKeyParameter keyParameter = null;
        try {
            keyParameter = PublicKeyFactory.createKey((byte[])publicKey);
        }
        catch (NullPointerException e) {
            throw new MosipNullKeyException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_KEY_EXCEPTION);
        }
        catch (IllegalArgumentException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_ASYMMETRIC_PUBLIC_KEY_EXCEPTION);
        }
        catch (IOException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_KEY_CORRUPT_EXCEPTION);
        }
        return keyParameter;
    }

    public static void checkMethod(MosipSecurityMethod mosipSecurityMethod) {
        if (mosipSecurityMethod == null) {
            throw new MosipNullMethodException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_METHOD_EXCEPTION);
        }
    }
}

